% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateQualificationType.R
\name{CreateQualificationType}
\alias{CreateQualificationType}
\alias{createqual}
\title{Create QualificationType}
\usage{
CreateQualificationType(
  name,
  description,
  status,
  keywords = NULL,
  retry.delay = NULL,
  test = NULL,
  answerkey = NULL,
  test.duration = NULL,
  auto = NULL,
  auto.value = NULL,
  verbose = getOption("pyMTurkR.verbose", TRUE)
)
}
\arguments{
\item{name}{A name for the QualificationType. This is visible to workers. It
cannot be modified by \code{\link{UpdateQualificationType}}.}

\item{description}{A longer description of the QualificationType. This is
visible to workers. Maximum of 2000 characters.}

\item{status}{A character vector of \dQuote{Active} or \dQuote{Inactive},
indicating whether the QualificationType should be active and visible.}

\item{keywords}{An optional character string containing a comma-separated
set of keywords by which workers can search for the QualificationType.
Maximum 1000 characters. These cannot be modified by
\code{\link{UpdateQualificationType}}.}

\item{retry.delay}{An optional time (in seconds) indicating how long workers
have to wait before requesting the QualificationType after an initial
rejection. If not specified, retries are disabled and Workers can request a
Qualification of this type only once, even if the Worker has not been
granted the Qualification.}

\item{test}{An optional character string consisting of a QuestionForm data
structure, used as a test a worker must complete before the
QualificationType is granted to them.}

\item{answerkey}{An optional character string consisting of an AnswerKey
data structure, used to automatically score the test}

\item{test.duration}{An optional time (in seconds) indicating how long
workers have to complete the test.}

\item{auto}{A logical indicating whether the Qualification is automatically
granted to workers who request it. Default is \code{NULL} meaning
\code{FALSE}.}

\item{auto.value}{An optional parameter specifying the value that is
automatically assigned to workers when they request it (if the Qualification
is automatically granted).}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A data frame containing the QualificationTypeId and other details of
the newly created QualificationType.
}
\description{
Create a QualificationType. This creates a QualificationType, but does not
assign it to any workers. All characteristics of the QualificationType
(except name and keywords) can be changed later with
\code{\link{UpdateQualificationType}}.
}
\details{
A function to create a QualificationType. Active QualificationTypes are
visible to workers and to other requesters. All characteristics of the
QualificationType, other than the name and keywords, can later be modified
by \code{\link{UpdateQualificationType}}. Qualifications can then be used to
assign Qualifications to workers with \code{\link{AssignQualification}} and
invoked as QualificationRequirements in \code{\link{RegisterHITType}} and/or
\code{\link{CreateHIT}} operations.

\code{createqual()} is an alias.
}
\examples{

\dontrun{
# Create a Qualification Type
qual1 <- CreateQualificationType(name="Worked for me before",
           description="This qualification is for people who have worked for me before",
           status = "Active",
           keywords = "Worked for me before")
DisposeQualificationType(qual1$QualificationTypeId)


# Create a Qualification Type with a Qualification Test
f <- system.file("templates/qualificationtest1.xml", package = "pyMTurkR")
QuestionForm <- paste0(readLines(f, warn = FALSE), collapse = "")

qual2 <- CreateQualificationType(name = "Qual0001",
                        description = "This is a qualification",
                        status = "Active",
                        test = QuestionForm,
                        test.duration = 30)
DisposeQualificationType(qual2$QualificationTypeId)


# Create a Qualification Type with a Qualification Test and Answer Key
f <- system.file("templates/qualificationtest1.xml", package = "pyMTurkR")
QuestionForm <- paste0(readLines(f, warn = FALSE), collapse = "")
f <- system.file("templates/answerkey1.xml", package = "pyMTurkR")
AnswerKey <- paste0(readLines(f, warn = FALSE), collapse = "")

qual3 <- CreateQualificationType(name = "Qual0001",
                        description = "This is a qualification",
                        status = "Active",
                        test = QuestionForm,
                        test.duration = 30,
                        answerkey = AnswerKey)
DisposeQualificationType(qual3$QualificationTypeId)
}

}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateQualificationTypeOperation.html}{API
Reference}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{Qualifications}
