% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_cells1.R
\name{px_precision}
\alias{px_precision}
\alias{px_precision.px}
\title{PRECISION}
\usage{
px_precision(x, value, validate)

\method{px_precision}{px}(x, value, validate = TRUE)
}
\arguments{
\item{x}{A px object}

\item{value}{Optional. A data frame with the columns 'precision' and one or more of the columns: 'variable-code', and 'code'. If 'value' is missing, the current PRECISION is returned. If NULL, PRECISION is removed.}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object or data frame.
}
\description{
Inspect or change PRECISION.
}
\examples{
# Set PRECISION for a variable
library(tibble)
x1 <-
  population_gl |>
  px() |>
  px_precision(tribble(~`variable-code`, ~precision,
                       'gender', 2))

# Print PRECISION
px_precision(x1)

# Set PRECISION for a value
x2 <-
  x1 |>
  px_precision(tribble(~`variable-code`, ~code, ~precision,
                       'age', '2004', 3))
px_precision(x2)

# Remove PRECISION
x3 <- px_precision(x2, NULL)
px_precision(x3)
}
\seealso{
\href{https://www.scb.se/globalassets/vara-tjanster/px-programmen/px-file_format_specification_2013.pdf#\%5B\%7B\%22num\%22\%3A51\%2C\%22gen\%22\%3A0\%7D\%2C\%7B\%22name\%22\%3A\%22XYZ\%22\%7D\%2C184\%2C385\%2C0\%5D}{Statistics Sweden's documentation}
}
