% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mkStruct}
\alias{mkStruct}
\title{Building Design Matrices and Covariance Structures for Linear Mixed Models}
\usage{
mkStruct(formula, data, corcall)
}
\arguments{
\item{formula}{a model formula.}

\item{data}{a data frame containing the variables used in the model.}

\item{corcall}{a \code{call} object specifying the residual correlation structure.
If NULL, an identity matrix is assumed.}
}
\value{
A list containing:
\itemize{
\item \code{data}: Processed data frame with NA values omitted.
\item \code{fxTrms}: Fixed-effects design structure, including model frame and design matrix.
\item \code{reTrms}: Random-effects structure (if applicable), including grouping factors,
design matrices, and variance-covariance matrix.
\item \code{rTrms}: Residual structure (R-side variance-covariance components).
\item \code{formula}: Expanded model formula.
}
}
\description{
Constructs design matrices for fixed and random effects, along with
variance-covariance structures for random effects (G-side) and residuals (R-side).
}
\keyword{internal}
