% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwsem.R
\name{vanishing.tetrads}
\alias{vanishing.tetrads}
\title{The vanishing.tetrads function}
\usage{
vanishing.tetrads(dat, sig = 0.05, bootstrap = FALSE, B = 1000)
}
\arguments{
\item{dat}{A data frame containing the observed variables.  No other
variables can be in this file, such as ones
describing the nesting structure.}

\item{sig}{A numerical value between 0 and 1 giving the
significance level to use when judging (conditional) independence.  The
default value is 0.05.}

\item{bootstrap}{A logical value specifying if you want bootstrap
probabilities or not.  Defaults to FALSE}

\item{B}{The number of bootstrap samples required.  Defaults to 1000.}
}
\value{
Just output to the screen listing each tetrad equation, its
value and its significance level.
}
\description{
This function implements the vanishing tetrads theorem of
Spirtes, Glymour & Scheines (1993).  If a set of four variables in dat
has a saturated unoriented dependency graph in CI.algorithm, and a
tetrad equation is zero, then this is evidence for a latent variable.
}
\examples{
#Determines which of the three tetrad equations are zero in this data set
#having 500 observations and 4 variables.  Since this set of 4 variables
#has a saturated partially oriented dependency graph,
#as shown using the CI.algorithm function, the tetrad equations
#that are zero (i.e. vanish) identify where latent variables occur that
#are common causes of these variables
#Since this is a saturated partially oriented dependency graph:
vanishing.tetrads(dat=sim_tetrads,sig=0.05)
}
