% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMSaturated.R
\name{FMSaturated}
\alias{FMSaturated}
\title{Saturated fresh mass estimation}
\usage{
FMSaturated(
  data,
  sample = "sample",
  water.potential = "water.potential",
  fresh.mass = "fresh.mass",
  dry.mass = "dry.mass"
)
}
\arguments{
\item{data}{data frame, at least with a column containing numeric water potential (MPa), fresh.mass (g) and dry.mass (g) values,
ordered by sample by descending water potential.
A column containing the sample IDs is optionally required if several samples were measured.}

\item{sample}{optional name of the column in data containing the sample IDs, default: "sample"}

\item{water.potential}{optional name of the column in data containing the water potential values (MPa), default = "water.potential"}

\item{fresh.mass}{optional name of the column in data containing the fresh mass values (g), default: "fresh mass"}

\item{dry.mass}{optional name of the column containing the dry mass values (g), default: "dry.mass"}
}
\value{
the original data frame (data) extended by a numeric column containing the saturated fresh mass values ("fresh.mass.saturated")
}
\description{
Calculates saturated fresh mass by fitting fresh mass values above the turgor loss point linearly to water potential values.
}
\details{
Above the turgor loss point, a linear relationship between water content and water potential exists. Based on this premise,
saturated water content is found where water potential is zero. First, turgor loss point is calculated based on the relative leaf water
loss (fresh mass minus dry mass relativized by the maximum
leaf water content value). Then, data above the turgor loss point is extracted and fresh mass is fitted linearly to water potential.
The point where water potential of the linear regression line is zero is the saturated water content. \cr \cr Before using this function,
check the data for an initial plateau. Data points in the initial part of the water potential
versus RWD plot with a stronger then expected decline need to be omitted.
}
\examples{
# get example data
df <- pressure_volume_data
# extend the data frame by saturated fresh mass
df <- FMSaturated(df)

}
