\name{Data}
\alias{Data}
\alias{tinysim}
\alias{ptychoIn}
\alias{ptychoOut}
\docType{data}
\title{Sample Data}
\description{
  Data objects used in examples in this package.
}
\usage{
data(tinysim)
data(ptychoIn)
data(ptychoOut)
}
\format{
  The object \code{tinysim} is an object returned by
  \code{\link{createDataBayesModel}} with \code{mode} equal to
  \dQuote{pleiotropy}.

  The object \code{ptychoIn} is an object returned by
  \code{\link{createDataBayesModel}} with \code{mode} equal to
  \dQuote{gene}.

  The object \code{ptychoOut} is an object returned by
  \code{\link{ptycho}} applied to the data in \code{ptychoIn} using the
  \emph{Across Sites} prior.
}
\details{
  These data objects are constructed to illustrate certain features in the
  examples while still being small enough not to be burdensome.

  The object \code{tinysim} contains simulated data.  Its design matrix is
  100-by-10. It has 10 replicates, each with a 100-by-5 response matrix.  It
  is generated by \code{\link{createPubData}}.

  The object \code{ptychoIn} also contains simulated data generated by
  \code{\link{createPubData}}.  Its design matrix is 3000-by-10 because, for its
  effect sizes, \code{n} must be about that large to distinguish signal from
  noise as explained in the supplemental text to Stell and Sabatti (2015).  To
  keep the object small, it has only 1 replicate, which has only one response.

  The object \code{ptychoOut} is generated by
  \preformatted{
    G <- 2; p <- ncol(ptychoIn$X)
    groups <- createGroupsSim(G, p)
    state <- list(list(indic.grp=rep(FALSE,G),
                       indic.var=matrix(FALSE,nrow=p,ncol=1), tau=1),
                  list(indic.grp=rep(TRUE,G),
                       indic.var=matrix(TRUE,nrow=p,ncol=1), tau=1))
    ptychoOut <- ptycho(X=ptychoIn$X, y=ptychoIn$replicates[[1]]$y,
                        groups=groups, initStates=state,
                        only.means=10000*seq_len(5), random.seed=12345)
  }
}
\source{
  Stell, L. and Sabatti, C. (2015) Genetic variant selection: learning across
  traits and sites, arXiv:1504.00946.
}
\seealso{\code{\link{createPubData}}, \code{\link{ptycho}}}
\keyword{datasets}
