% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_construct_overview.R,
%   R/generate_definitions_overview.R, R/generate_instruction_overview.R
\name{generate_construct_overview}
\alias{generate_construct_overview}
\alias{generate_instruction_overview}
\alias{generate_definitions_overview}
\title{Generate construct overviews and instruction overviews}
\usage{
generate_construct_overview(
  dctSpec,
  include = c("definition", "measure_dev", "measure_code", "manipulate_dev",
    "manipulate_code", "aspect_dev", "aspect_code", "rel"),
  hideByDefault = NULL,
  divClass = "btn btn-secondary",
  headingLevel = 3,
  collapseButtons = TRUE,
  hyperlink_UCIDs = TRUE,
  HTMLoutput = FALSE,
  urlPrefix = "#",
  sortDecreasing = FALSE
)

generate_definitions_overview(
  dctSpecDf,
  headingLevel = 3,
  hyperlink_UCIDs = "Markdown",
  urlPrefix = "#",
  sortDecreasing = FALSE
)

generate_instruction_overview(
  dctSpecDf,
  type,
  headingLevel = 3,
  hyperlink_UCIDs = "Markdown",
  urlPrefix = "#",
  sortDecreasing = FALSE
)
}
\arguments{
\item{dctSpec}{The DCT specification, as resulting from a call
to \code{\link[=load_dct_specs]{load_dct_specs()}} or \code{\link[=load_dct_dir]{load_dct_dir()}}.}

\item{include}{Which elements to include in the construct overview.}

\item{hideByDefault}{Which elements to hide by default.}

\item{divClass}{The class of the button to collapse/expand sections.}

\item{headingLevel}{The level of the heading in the Markdown output
that is produces.}

\item{collapseButtons}{Whether to include buttons to show/hide the definition
and instructions.}

\item{hyperlink_UCIDs}{Whether to create hyperlinks to UCIDs.}

\item{HTMLoutput}{Whether to output to Markdown (\code{FALSE}) or HTML (\code{TRUE}).}

\item{urlPrefix}{The prefix to insert before the URL in the produced
hyperlink. The default, "\verb{#}", results in a link to an
anchor (an HTML \code{a} element) on the current page.}

\item{sortDecreasing}{Whether to sort the constructs in decreasing order
(\code{TRUE}), in increasing order (\code{FALSE}), or not at all (\code{NULL}).}

\item{dctSpecDf}{The DCT specification dataframer, as produced
by a call to \code{\link[=load_dct_specs]{load_dct_specs()}} or \code{\link[=load_dct_dir]{load_dct_dir()}}, and stored within
the resulting object.}

\item{type}{For instruction overviews, the type of instruction
to generate can be specified: must be one of "\code{measure_dev}",
"\code{measure_code}", "\code{manipulate_dev}", "\code{manipulate_code}",
"\code{aspect_dev}", or "\code{aspect_code}".}
}
\value{
A character string with the overview.
}
\description{
These functions use a DCT specification to generate a
construct overview or an instruction overview.
}
\examples{
exampleDCT <-
  psyverse::dct_object(
    prefix = "exampleConstruct",
    label = "An example construct",
    definition = "The definition goes here",
    measure_dev = "Here you can explain how to measure the construct"
  );
generate_construct_overview(exampleDCT);
}
