% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttest.R
\name{tValueString}
\alias{tValueString}
\title{tValueString}
\usage{
tValueString(tObj)
}
\arguments{
\item{tObj}{The returned object from a call to t.test}
}
\value{
character
}
\description{
Returns required Latex formatted string for \emph{t}(df) = XXX for
R/knitr integration. Returns values to 2 sig decimal places.
}
\examples{
# Example 1:
# create dataframe and add data with 2(Comp: comp vs. incomp) levels
dat <- createDF(nVP = 50,
                nTrl = 1,
                design = list("Comp" = c("comp", "incomp")))

dat <- addDataDF(dat, RT = list("Comp comp"   = c(500, 100, 100),
                                "Comp incomp" = c(600, 100, 100)))

tObj <- t.test(dat$RT[dat$Comp == "incomp"],
               dat$RT[dat$Comp == "comp"],
               paired = TRUE)

tString <- tValueString(tObj)

}
