% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttest.R
\name{meanStrT}
\alias{meanStrT}
\title{meanStrT}
\usage{
meanStrT(tObj, numDigits = 0, unit = "")
}
\arguments{
\item{tObj}{The returned object from a call to t.test}

\item{numDigits}{The number of digits to round to}

\item{unit}{"" vs. "ms" vs. "mv" vs. "\%"}
}
\value{
character
}
\description{
Returns a string with the mean value from a t.test in Latex format.
}
\examples{
# Example 1:
# create dataframe and add data
dat <- createDF(nVP = 50,
                nTrl = 1,
                design = list("Comp" = c("comp", "incomp")))

dat <- addDataDF(dat, RT = list("Comp comp"   = c(500, 100, 100),
                                "Comp incomp" = c(600, 100, 100)))

tObj <- t.test(dat$RT[dat$Comp == "incomp"],
               dat$RT[dat$Comp == "comp"],
               paired = TRUE)

tString <- meanStrT(tObj, numDigits = 0, unit = "ms")

}
