% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDecoyDB.R
\name{createDecoyDB}
\alias{createDecoyDB}
\title{Create db with decoys and contaminants}
\usage{
createDecoyDB(
  dbs,
  useContaminants = loadContaminantsFasta2021(),
  revLab = "REV_",
  annot = "zz|sourceOf|database"
)
}
\arguments{
\item{dbs}{a path to a fasta file or an array of files}

\item{useContaminants}{list with contaminant sequences}

\item{revLab}{label for reversed peptides (if NULL do not generate decoys)}

\item{annot}{source of database}
}
\value{
list of SeqFastaAA entries
}
\description{
For more details and references see package vignette
\code{vignette("CreateDecoyDB", package = "prozor")}
}
\examples{
file = system.file("extdata/fgcz_contaminants2021_20210929.fasta.gz",package="prozor")
cont <- loadContaminantsFasta2021()
rabbit <-readPeptideFasta(file)
tmp <- 2*(2*length(rabbit)+length(cont)) + 1

res <- createDecoyDB(c(file,file))
length(res)
stopifnot(length(res) == tmp)

res <- createDecoyDB(c(file,file), revLab=NULL)
stopifnot(length(res) == (2*length(rabbit)+length(cont) + 1))
res <- createDecoyDB(c(file,file), revLab=NULL, useContaminants = NULL)
stopifnot(length(res) == (2*length(rabbit) + 1) )

}
