% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotatePeptides.R
\name{annotateAHO}
\alias{annotateAHO}
\title{annotate peptides using AhoCorasickTrie}
\usage{
annotateAHO(pepseq, fasta)
}
\arguments{
\item{pepseq}{- list of peptides - sequence, optional modified sequence, charge state.}

\item{fasta}{- object as created by \code{readPeptideFasta}}
}
\value{
A data.frame with proteinID, peptideSeq, Offset and proteinSequence
}
\description{
peptides which do not have protein assignment drop out
}
\examples{

library(dplyr)

file = system.file("extdata/IDResults.txt.gz" , package = "prozor")
specMeta <- readr::read_tsv(file)
upeptide <- unique(specMeta$peptideSeq)
resCan <-
   prozor::readPeptideFasta(
       system.file("p1000_db1_example/Annotation_canSeq.fasta.gz" , package = "prozor"))
resCanU <- resCan[!duplicated(unlist(resCan))]
annotAll = annotateAHO(upeptide[seq_len(20)], resCanU)
dim(annotAll)

}
