% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sircombe.R
\name{SH.diss}
\alias{SH.diss}
\title{Sircombe and Hazelton distance}
\usage{
SH.diss(x, i, j, c.con = 0)
}
\arguments{
\item{x}{an object of class \code{distributional}}

\item{i}{index of the first sample}

\item{j}{index of the second sample}

\item{c.con}{smoothing bandwidth of the kernel functional estimate}
}
\value{
a scalar value expressing the L2 distance between the KFEs
of samples i and j
}
\description{
Calculates Sircombe and Hazelton's L2 distance between the Kernel
Functional Estimates (KFEs, not to be confused with Kernel Density
Estimates!) of two samples with specified analytical uncertainties
}
\examples{
datfile <- system.file("Namib/DZ.csv",package="provenance")
errfile <- system.file("Namib/DZerr.csv",package="provenance")
DZ <- read.distributional(datfile,errfile)
d <- SH.diss(DZ,1,2)
print(d)
}
\references{
Sircombe, K. N., and M. L. Hazelton. "Comparison of
detrital zircon age distributions by kernel functional estimation."
Sedimentary Geology 171.1 (2004): 91-111.
}
\seealso{
KS.diss
}
\author{
Keith Sircombe and Martin Hazelton
}
