% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read.densities}
\alias{read.densities}
\title{Read a .csv file with mineral and rock densities}
\usage{
read.densities(
  fname,
  sep = ",",
  dec = ".",
  header = TRUE,
  check.names = FALSE,
  ...
)
}
\arguments{
\item{fname}{a string with the path to the .csv file}

\item{sep}{the field separator character.  Values on each line of
the file are separated by this character.}

\item{dec}{the character used in the file for decimal points.}

\item{header}{a logical value indicating whether the file contains
the names of the variables as its first line.}

\item{check.names}{logical.  If \code{TRUE} then the names of the
variables in the frame are checked to ensure that they are
syntactically variable names.}

\item{...}{optional arguments to the built-in \code{read.table}
function}
}
\value{
a vector with mineral and rock densities
}
\description{
Reads a data table containing densities to be used for
hydraulic sorting corrections (minsorting and srd functions)
}
\examples{
data(Namib,densities)
N8 <- subset(Namib$HM,select="N8")
distribution <- minsorting(N8,densities,phi=2,sigmaphi=1,medium="air",by=0.05)
plot(distribution)
}
