/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.stream;

import com.qarks.util.Cancellable;
import com.qarks.util.proxy.client.HttpInvocationHandler;
import com.qarks.util.stream.CommunicationUtilities;
import com.qarks.util.stream.StreamCopyListener;
import com.qarks.util.stream.StreamHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;

public class FileHelper {
    public static byte[] getDigest(byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[]{};
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byArray2 = messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException(noSuchAlgorithmException.getMessage());
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(File file, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, string);
            char[] cArray = new char[2000];
            int n = 0;
            while ((n = inputStreamReader.read(cArray)) > -1) {
                if (n > 0) {
                    stringBuffer.append(cArray, 0, n);
                    continue;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
            inputStreamReader.close();
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(File file) throws IOException {
        FileReader fileReader = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            fileReader = new FileReader(file);
            char[] cArray = new char[2000];
            int n = 0;
            while ((n = fileReader.read(cArray)) > -1) {
                if (n > 0) {
                    stringBuffer.append(cArray, 0, n);
                    continue;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
        }
        return stringBuffer.toString();
    }

    public static String getFileContent(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            char[] cArray = new char[2000];
            int n = 0;
            while ((n = inputStreamReader.read(cArray)) > -1) {
                if (n > 0) {
                    stringBuffer.append(cArray, 0, n);
                    continue;
                }
                Thread.sleep(50L);
            }
            inputStreamReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static String getFileContent(InputStream inputStream, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
            char[] cArray = new char[2000];
            int n = 0;
            while ((n = inputStreamReader.read(cArray)) > -1) {
                if (n > 0) {
                    stringBuffer.append(cArray, 0, n);
                    continue;
                }
                Thread.sleep(50L);
            }
            inputStreamReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static void writeUrlContentToFile(String string, File file, StreamCopyListener streamCopyListener, Cancellable cancellable) throws IOException {
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)CommunicationUtilities.connectToServer(uRL);
        HttpInvocationHandler.applySSLSocketFactory(httpURLConnection);
        InputStream inputStream = httpURLConnection.getInputStream();
        int n = httpURLConnection.getContentLength();
        FileHelper.writeContentToFile(inputStream, n, file, streamCopyListener, cancellable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeContentToFile(InputStream inputStream, int n, File file, StreamCopyListener streamCopyListener, Cancellable cancellable) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[2000];
            int n2 = 0;
            for (int i = 0; !(i >= n || cancellable != null && cancellable.isCancelled()); i += n2) {
                n2 = inputStream.read(byArray);
                if (n2 == -1) {
                    throw new IOException("could not read the requested length in the given stream");
                }
                if (n2 > 0) {
                    outputStream.write(byArray, 0, n2);
                    if (streamCopyListener == null) continue;
                    streamCopyListener.onLengthChanged(i, n);
                    continue;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
            }
            if (cancellable != null && cancellable.isCancelled()) {
                System.out.println("download cancelled");
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeContentToFile(String string, File file) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = string.getBytes();
            outputStream.write(byArray);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeContentToFile(InputStream inputStream, File file) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[2048];
            int n = 0;
            while ((n = inputStream.read(byArray)) > -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileBytes(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = new byte[2000];
            int n = 0;
            while ((n = inputStream.read(byArray)) > -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytesToFile(byte[] byArray, File file) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            outputStream.write(byArray);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public static boolean deleteDir(File file) {
        FileHelper.cleanDir(file);
        return file.delete();
    }

    public static boolean cleanDir(File file) {
        File file2;
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return false;
        }
        if (!file2.equals(file.getAbsoluteFile())) {
            return false;
        }
        File[] fileArray = file2.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file3 = fileArray[i];
                boolean bl = file3.delete();
                if (bl || !file3.isDirectory()) continue;
                FileHelper.deleteDir(file3);
            }
        }
        return true;
    }

    public static long getDirectorySize(File file) {
        long l = 0L;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                l += FileHelper.getDirectorySize(fileArray[i]);
            }
        } else {
            l = file.length();
        }
        return l;
    }

    public static int replaceString(File file, String string, String string2) throws IOException {
        Object object;
        int n = 0;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        Vector<String> vector = new Vector<String>();
        while (true) {
            if ((object = bufferedReader.readLine()) == null) break;
            StringBuffer stringBuffer = new StringBuffer(256);
            for (int i = 0; i < ((String)object).length(); ++i) {
                if (((String)object).regionMatches(i, string, 0, string.length())) {
                    stringBuffer.append(string2);
                    i += string.length() - 1;
                    ++n;
                    continue;
                }
                stringBuffer.append(((String)object).charAt(i));
            }
            vector.addElement(stringBuffer.toString());
        }
        bufferedReader.close();
        object = new BufferedWriter(new FileWriter(file));
        for (int i = 0; i < vector.size(); ++i) {
            ((Writer)object).write((String)vector.elementAt(i));
            ((BufferedWriter)object).newLine();
        }
        ((BufferedWriter)object).close();
        return n;
    }

    public static void deleteHierarchy(File file) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                FileHelper.deleteHierarchy(fileArray[i]);
            }
            if (file.exists() && !file.delete()) {
                throw new IOException("folder " + file.getAbsolutePath() + " cannot be deleted");
            }
        }
        if (file.exists() && !file.delete()) {
            throw new IOException("file " + file.getAbsolutePath() + " cannot be deleted");
        }
    }

    public static void copyFileHierarchy(File file, File file2) throws IOException {
        FileHelper.copyFileHierarchy(file, file2, null);
    }

    public static void copyFile(File file, File file2) throws FileNotFoundException, IOException {
        FileHelper.copyFile(file, file2, null);
    }

    public static void moveDir(File file, File file2) throws IOException {
        FileHelper.copyFileHierarchy(file, file2);
        FileHelper.deleteDir(file);
    }

    public static File copyFileInDirectory(File file, File file2) throws IOException {
        if (!file2.isDirectory()) {
            throw new IOException("not a directory");
        }
        String string = file2.getAbsolutePath();
        if (!string.endsWith("\\") && !string.endsWith("/")) {
            string = string + File.separator;
        }
        String string2 = file.getName();
        int n = string2.lastIndexOf(".");
        String string3 = "";
        if (n > 0) {
            string3 = string2.substring(n);
            string2 = string2.substring(0, n);
        }
        File file3 = new File(string + string2 + string3);
        int n2 = 1;
        while (file3.exists()) {
            file3 = new File(string + string2 + "~" + n2 + string3);
            ++n2;
        }
        FileHelper.copyFile(file, file3);
        return file3;
    }

    public static void setWritable(File file) throws IOException {
        boolean bl = file.setWritable(true);
        if (!bl) {
            System.err.println("native API to set file writable failed, trying legacy..");
            FileHelper.setWritable(file, null);
        }
    }

    public static void setWritable(File file, StreamCopyListener streamCopyListener) throws IOException {
        if (!file.canWrite()) {
            File file2 = file;
            boolean bl = true;
            String string = file.getName();
            int n = 1;
            File file3 = null;
            File file4 = file.getParentFile();
            while (bl) {
                file3 = new File(file4, string + "~" + n);
                bl = file3.exists();
                ++n;
            }
            if (!file.renameTo(file3)) {
                throw new IOException("could not set the file writable");
            }
            FileHelper.copyFile(file3, file2, streamCopyListener);
            file3.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2, StreamCopyListener streamCopyListener) throws FileNotFoundException, IOException {
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            StreamHelper streamHelper = new StreamHelper();
            if (streamCopyListener != null) {
                streamCopyListener.onFileCopyStart(file);
            }
            outputStream = new BufferedOutputStream(new FileOutputStream(file2));
            inputStream = new BufferedInputStream(new FileInputStream(file));
            streamHelper.doCopy(file, inputStream, outputStream, streamCopyListener);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static void copyFileHierarchy(File file, File file2, StreamCopyListener streamCopyListener) throws IOException {
        if (file.isDirectory()) {
            String string = file2.getAbsolutePath() + File.separator + file.getName();
            File file3 = new File(string);
            if (!file3.exists()) {
                file3.mkdirs();
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file4 = new File(file.getPath(), stringArray[i]);
                File file5 = new File(string);
                FileHelper.copyFileHierarchy(file4, file5, streamCopyListener);
            }
        } else {
            if (file2.isDirectory()) {
                String string = file2.getAbsolutePath() + File.separator + file.getName();
                file2 = new File(string);
            }
            FileHelper.copyFile(file, file2, streamCopyListener);
            long l = file.lastModified();
            boolean bl = file.canWrite();
            file2.setLastModified(l);
            if (!bl) {
                file2.setReadOnly();
            }
        }
    }

    public static File download(URL uRL, String string, StreamCopyListener streamCopyListener, File file, Cancellable cancellable) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        HttpInvocationHandler.applySSLSocketFactory(uRLConnection);
        File file2 = new File(file, string);
        String string2 = "";
        String string3 = string;
        int n = string3.lastIndexOf(".");
        if (n > -1) {
            string2 = string3.substring(n);
            string3 = string3.substring(0, n);
        }
        n = 1;
        while (file2.exists()) {
            file2 = new File(file, string3 + "~" + n + string2);
            ++n;
        }
        file2.deleteOnExit();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        FileHelper.writeContentToFile(bufferedInputStream, uRLConnection.getContentLength(), file2, streamCopyListener, cancellable);
        return file2;
    }

    public static String replaceIllegals(String string, char c) {
        String string2 = string;
        char[] cArray = new char[]{'/', '\\', ':', '*', '?', '<', '>', '|'};
        for (int i = 0; i < cArray.length; ++i) {
            string2 = string2.replace(cArray[i], '_');
        }
        return string2;
    }
}

