/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.stream;

import com.qarks.util.stream.CorePipedOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class CorePipedInputStream
extends InputStream {
    private boolean mClosed = false;
    boolean mConnected = false;
    CorePipedOutputStream mPos = null;
    private static byte[] skipBuffer;
    private static final int SKIP_BUFFER_SIZE = 2048;
    private byte[] b = new byte[1];

    public CorePipedInputStream(CorePipedOutputStream corePipedOutputStream) throws IOException {
        this.connect(corePipedOutputStream);
    }

    public CorePipedInputStream() {
    }

    public void connect(CorePipedOutputStream corePipedOutputStream) throws IOException {
        this.mPos = corePipedOutputStream;
        this.mConnected = true;
        this.mPos.mPis = this;
        this.mPos.mConnected = true;
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.b);
        if (n >= 0) {
            return this.b[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public long skip(long l) throws IOException {
        int n;
        long l2 = l;
        if (skipBuffer == null) {
            skipBuffer = new byte[2048];
        }
        byte[] byArray = skipBuffer;
        if (l <= 0L) {
            return 0L;
        }
        while (l2 > 0L && (n = this.read(byArray, 0, (int)Math.min(2048L, l2))) >= 0) {
            l2 -= (long)n;
        }
        return l - l2;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.mConnected) {
            throw new IOException("InputPipe not connected");
        }
        if (this.mClosed) {
            throw new IOException("InputPipe closed");
        }
        return this.mPos.receive(byArray, n, n2);
    }

    @Override
    public synchronized int available() throws IOException {
        if (!this.mConnected) {
            throw new IOException("InputPipe not connected");
        }
        int n = this.mPos.available();
        return n;
    }

    @Override
    public void close() throws IOException {
        this.mClosed = true;
        if (!this.mPos.isClosed()) {
            this.mPos.close();
        }
    }

    void open() {
        this.mClosed = false;
    }

    public boolean isClosed() {
        return this.mClosed;
    }
}

