% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provTraceR.R
\name{prov.trace}
\alias{prov.trace}
\alias{prov.trace.run}
\title{File lineage functions}
\usage{
prov.trace(
  scripts,
  prov.dir = NULL,
  file.details = FALSE,
  console = TRUE,
  save = FALSE,
  save.dir = NULL,
  check = TRUE
)

prov.trace.run(
  scripts,
  prov.dir = NULL,
  file.details = FALSE,
  console = TRUE,
  save = FALSE,
  save.dir = NULL,
  check = TRUE,
  prov.tool = "rdtLite",
  details = FALSE,
  ...
)
}
\arguments{
\item{scripts}{a script name, a vector of script names, or a text file of 
script names (file extension = .txt)}

\item{prov.dir}{provenance directory}

\item{file.details}{whether to display file details}

\item{console}{whether to display results in the console}

\item{save}{whether to save results to the file prov-trace.txt}

\item{save.dir}{where to save the results file. If NULL, use the R session 
temporary directory. If a period (.), use the current working directory.
Otherwise use save.dir.}

\item{check}{whether to check against the user's file system}

\item{prov.tool}{provenance collection tool (rdtLite or rdt)}

\item{details}{whether to collect fine-grained provenance}

\item{...}{other parameters passed to the provenance collector}
}
\value{
string containing file lineage

string containing file lineage
}
\description{
prov.trace traces file lineage from existing provenance.

prov.trace.run runs the specified script(s), collects provenance, and uses
the provenance to trace file lineage.
}
\examples{
prov.dir <- system.file("testdata", package="provTraceR")
prov.trace(c("script-1.R", "script-2.R"), prov.dir=prov.dir)
}
