% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/par-01-parSeqSim.R
\name{parSeqSim}
\alias{parSeqSim}
\title{Parallel Protein Sequence Similarity Calculation Based on
Sequence Alignment (In-Memory Version)}
\usage{
parSeqSim(
  protlist,
  cores = 2,
  batches = 1,
  verbose = FALSE,
  type = "local",
  submat = "BLOSUM62",
  gap.opening = 10,
  gap.extension = 4
)
}
\arguments{
\item{protlist}{A length \code{n} list containing \code{n} protein sequences,
each component of the list is a character string, storing one protein
sequence. Unknown sequences should be represented as \code{""}.}

\item{cores}{Integer. The number of CPU cores to use for parallel execution,
default is \code{2}. Users can use the \code{availableCores()} function
in the parallelly package to see how many cores they could use.}

\item{batches}{Integer. How many batches should we split the pairwise
similarity computations into. This is useful when you have a large
number of protein sequences, enough number of CPU cores, but not
enough RAM to compute and fit all the pairwise similarities
into a single batch. Defaults to 1.}

\item{verbose}{Print the computation progress?
Useful when \code{batches > 1}.}

\item{type}{Type of alignment, default is \code{"local"},
can be \code{"global"} or \code{"local"},
where \code{"global"} represents Needleman-Wunsch global alignment;
\code{"local"} represents Smith-Waterman local alignment.}

\item{submat}{Substitution matrix, default is \code{"BLOSUM62"},
can be one of \code{"BLOSUM45"}, \code{"BLOSUM50"}, \code{"BLOSUM62"},
\code{"BLOSUM80"}, \code{"BLOSUM100"}, \code{"PAM30"},
\code{"PAM40"}, \code{"PAM70"}, \code{"PAM120"}, or \code{"PAM250"}.}

\item{gap.opening}{The cost required to open a gap of any length
in the alignment. Defaults to 10.}

\item{gap.extension}{The cost to extend the length of an existing
gap by 1. Defaults to 4.}
}
\value{
A \code{n} x \code{n} similarity matrix.
}
\description{
Parallel calculation of protein sequence similarity based on
sequence alignment.
}
\examples{
\dontrun{

# Be careful when testing this since it involves parallelization
# and might produce unpredictable results in some environments

library("Biostrings")
library("foreach")
library("doParallel")

s1 <- readFASTA(system.file("protseq/P00750.fasta", package = "protr"))[[1]]
s2 <- readFASTA(system.file("protseq/P08218.fasta", package = "protr"))[[1]]
s3 <- readFASTA(system.file("protseq/P10323.fasta", package = "protr"))[[1]]
s4 <- readFASTA(system.file("protseq/P20160.fasta", package = "protr"))[[1]]
s5 <- readFASTA(system.file("protseq/Q9NZP8.fasta", package = "protr"))[[1]]
plist <- list(s1, s2, s3, s4, s5)
(psimmat <- parSeqSim(plist, cores = 2, type = "local", submat = "BLOSUM62"))
}
}
\seealso{
See \code{\link{parSeqSimDisk}} for the disk-based version.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
