% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{resample}
\alias{resample}
\title{Resample spectral data}
\usage{
resample(X, wav, new.wav, interpol = "spline", ...)
}
\arguments{
\item{X}{numeric matrix or vector to resample (optionally a data frame that
can be coerced to a numerical matrix).}

\item{wav}{a numeric vector giving the original band positions.}

\item{new.wav}{a numeric vector giving the new band positions.}

\item{interpol}{the interpolation method: 'linear' or 'spline' (default).}

\item{...}{additional arguments to be passed to the \code{\link{splinefun}}
function when \code{interpol = 'spline'}.}
}
\value{
a matrix or vector with resampled values.
}
\description{
Resample a data matrix or vector to new coordinates (e.g.
band positions) using spline or linear interpolation. This function is a
simple wrapper around \code{\link{approx}} and \code{\link{splinefun}} in
\pkg{base}.
}
\examples{
data(NIRsoil)
wav <- as.numeric(colnames(NIRsoil$spc))
# increase spectral resolution by 2
NIRsoil$spc_resampled <- resample(NIRsoil$spc, wav, seq(1100, 2498, 2))
dim(NIRsoil$spc)
dim(NIRsoil$spc_resampled)
}
\seealso{
\code{\link{resample2}}
}
\author{
Antoine Stevens and \href{https://orcid.org/0000-0002-5369-5120}{Leonardo Ramirez-Lopez}
}
