% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{roulette}
\alias{roulette}
\title{Roulette}
\usage{
roulette(european = FALSE, makespace = FALSE)
}
\arguments{
\item{european}{logical. Use a European roulette wheel with 37 pockets if \code{TRUE}, otherwise use a standard US roulette wheel with 38 pockets.}

\item{makespace}{logical. Include a column of equally likely probabilities if \code{TRUE}.}
}
\value{
A data frame, with columns \code{num} and \code{color}, and an equally likely \code{probs} column if \code{makespace} is \code{TRUE}.
}
\description{
Sets up a sample space for the experiment of spinning a roulette wheel once.
}
\details{
If \code{european} is \code{TRUE}, then a traditional EU roulette wheel with 37 pockets is used, otherwise, a standard US roulette wheel with 38 pockets is used. Entries in the data frame are ordered in the customary way to facilitate the calculation probabilities regarding called bets.
}
\examples{
roulette()
roulette(european = TRUE, makespace = TRUE)

}
\seealso{
\code{\link[probs]{cards}}
}
\author{
G. Jay Kerns \email{gkerns@ysu.edu}.
}
\keyword{misc}
