% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{intersect.ps}
\alias{intersect.ps}
\title{Intersection of Subsets
Calculates the intersection of subsets of a probability space.  Comparisons are made row-wise, so that in the data frame case, \code{intersect(A,B)} is a data frame with those rows that are both in \code{A} and in \code{B}.}
\usage{
\method{intersect}{ps}(x, y, ...)
}
\arguments{
\item{x}{vectors, data frames, or \code{ps} objects containing a sequence of elements (conceptually).}

\item{y}{vectors, data frames, or \code{ps} objects containing a sequence of elements (conceptually).}

\item{...}{further arguments to be passed to or from other methods.}
}
\value{
A vector, data frame, or subset of a probability space of the same type as its arguments.
}
\description{
Intersection of Subsets
Calculates the intersection of subsets of a probability space.  Comparisons are made row-wise, so that in the data frame case, \code{intersect(A,B)} is a data frame with those rows that are both in \code{A} and in \code{B}.
}
\details{
This is a generic function, extended from the \code{intersect} function in the \code{base} package.  The elements of \code{intersect(x,y)} are those elements in \code{x} and in \code{y}. The original definition is preserved in the case that \code{x} and \code{y} are vectors of the same mode.
}
\examples{
S <- cards()
A <- subset(S, suit == "Heart")
B <- subset(S, rank == "A" )
intersect(A, B)
}
\seealso{
\code{\link[probs]{union}}, \code{\link[probs]{setdiff}}
}
\author{
G. Jay Kerns \email{gkerns@ysu.edu}, based on a suggestion made by Brian Ripley in \code{R}-devel, 12/11/07.
}
