% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genData.R
\name{gen2wayTable}
\alias{gen2wayTable}
\title{Generate Two-way Tables}
\usage{
gen2wayTable(
  n = sample(100:500, size = 1),
  pmatrix = matrix(1:12, nrow = 3),
  dmnames = list(X = paste("x", 1:nrow(pmatrix), sep = ""), Y = paste("y",
    1:ncol(pmatrix), sep = "")),
  addmargins = TRUE,
  as.df = FALSE,
  untable = TRUE
)
}
\arguments{
\item{n}{sum total observations}

\item{pmatrix}{matrix of nonnegative weights for the probability distribution}

\item{dmnames}{names of the table dimensions}

\item{addmargins}{should margins be added?}

\item{as.df}{table will be returned as a data frame}

\item{untable}{should counts be untabled to single observation per row}
}
\value{
An object of class table containing the generated values.
}
\description{
A function to randomly generate arbitrary two-way tables.
}
\author{
G. Jay Kerns
}
\keyword{datagen}
