% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m_step_func.R
\name{m_step_regression}
\alias{m_step_regression}
\title{Function for fitting the initial part of the M-step}
\usage{
m_step_regression(Y, W, W2, Z = NULL, a = -3/2, Int = TRUE)
}
\arguments{
\item{Y}{A matrix containing the outcome \code{Y}}

\item{W}{Quantity \eqn{E(W_0)} as outlined in citation, output from W_update_fun}

\item{W2}{Quantity \eqn{E(W^2_0)} as outlined in citation, output from W_update_fun}

\item{Z}{A matrix or dataframe of other predictors to account for}

\item{a}{(optional) parameter for changing the hyperparameter \eqn{a} (default, \eqn{a=-3/2} uses \eqn{n-2} as denominator for MAP of \eqn{\sigma^2})}

\item{Int}{(optional) Logical - should an intercept be used?}
}
\value{
A list including 

\code{coef} the MAP estimates of the \eqn{\alpha_0} parameters
\code{sigma2_est} the MAP estimate of \eqn{\sigma^2}
\code{VCV} posterior variance covariance matrix of \eqn{\alpha_0}, 
\code{res_data} dataframe containing MAP estimates, posterior variances, t-test statistics and associated p-values for \eqn{\alpha_0}
}
\description{
A wrapper function providing the quantities related to the M-step for \eqn{\alpha_0} and \eqn{\sigma^2}.
}
\references{
McLain, A. C., Zgodic, A., & Bondell, H. (2022). Sparse high-dimensional linear regression with a partitioned empirical Bayes ECM algorithm. arXiv preprint arXiv:2209.08139.
}
