% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/model.pro.R
\name{model.pro}
\alias{model.pro}
\title{Model matrix for point-process responses}
\usage{
model.pro(spike, flash, fixed = NULL, kv = F)
}
\arguments{
\item{spike}{A binary vector represents spiking (1) or no spiking (0).}

\item{flash}{A binary vector of the same length of \code{spike}, 1 for flashing and 0 for non-flashing.}

\item{fixed}{Whether a fixed time window of spike/flash history should be used. If  it is \code{NULL}, a varying time window of history will be used as described in the reference. If it is a integer \code{j}, a fixed window from index \code{t-j} to \code{t} will be used.}

\item{kv}{Whether the history dependence model in Kass and Ventura (2001) (A Spike-Train Probability Model, Neural Computation 13, 1713-1720) should be employed. This differs from the history dependence model in the reference.}
}
\value{
a \code{data.frame} of the three response functions (PF, CF, SF) and other intermediate functions (for future modeling use).
}
\description{
Constructs  a \code{data.frame} to be fitted using \code{\link{pro}}.
Reference: X Luo, S Gee, V Sohal, D Small (In Press). A Point-process Response Model for Optogenetics Experiments on Neural Circuits. _Statistics in Medicine_.
}
\examples{
n <- 500
set.seed(100)
re <- sim.lif(n, rbinom(n, 1, 0.14), 7, 3)
d <- model.pro(re$sbin, re$I)
d[1:10, ]
}

