% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{modify_hcl}
\alias{modify_hcl}
\title{Modify Individual HCL Axes}
\source{
\url{https://en.wikipedia.org/wiki/HCL_color_space}
}
\usage{
modify_hcl(col, h, c, l)
}
\arguments{
\item{col}{a color object or vector of any of the three kinds of R color
specifications, i.e., either a color name (as listed by colors()), a
hexadecimal string of the form "#rrggbb" or "#rrggbbaa" (see rgb), or a
positive integer i meaning palette()[i].}

\item{h}{Expression to modify the hue of `col`}

\item{c}{Expression to modify the chroma of `col`}

\item{l}{Expression to modify the luminance of `col`}
}
\value{
a colors object.
}
\description{
This function lets you modify individual axes of a color in HCL color space.
}
\details{
The expression used in `h`, `c`, and `l` is evaluated in the `hcl` space and
and you have access to `h`, `c`, and `l` as vectors along with vectors in the
calling environment.

`h` ranges from 0 to 360, `l` ranges from 0 to 100, and `c` while depended on
`h` and `l` will roughly be within 0 and 180, but often on a narrower range.
Colors after modification will be adjusted to fit within the color space.
}
\examples{
plot(modify_hcl("red", h = 160))
plot(modify_hcl("red", h = h + 50))

plot(modify_hcl("red", h = h + 1:100))
plot(modify_hcl("red", c = c - 1:200))
plot(modify_hcl("red", l = l + 1:50))

plot(modify_hcl(rainbow(10), l = 25))

plot(modify_hcl(rainbow(10), h + h / 2, l = 70))
}
