% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{clr_extract_red}
\alias{clr_extract_red}
\alias{clr_extract_green}
\alias{clr_extract_blue}
\alias{clr_extract_alpha}
\title{Extract RGB components}
\usage{
clr_extract_red(col)

clr_extract_green(col)

clr_extract_blue(col)

clr_extract_alpha(col)
}
\arguments{
\item{col}{a color object or vector of any of the three kinds of R color
specifications, i.e., either a color name (as listed by colors()), a
hexadecimal string of the form "#rrggbb" or "#rrggbbaa" (see rgb), or a
positive integer i meaning palette()[i].}
}
\value{
Numeric vector of values.
}
\description{
Extract the red, green, or blue color components from a vector of colors.
}
\details{
The values of the output will range between 0 and 255.

Use [clr_extract()] if you are planning to extraction multiple components.
}
\examples{
clr_extract_red(rainbow(100))
clr_extract_green(rainbow(100))
clr_extract_blue(rainbow(100))
clr_extract_alpha(rainbow(100))
}
\seealso{
Other Extraction: 
\code{\link{clr_extract}()},
\code{\link{clr_extract_chroma}()},
\code{\link{clr_extract_hue}()}
}
\concept{Extraction}
