% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{sim_data}
\alias{sim_data}
\alias{sim_pu_polygons}
\alias{sim_zones_pu_polygons}
\alias{sim_pu_points}
\alias{sim_pu_lines}
\alias{sim_pu_raster}
\alias{sim_locked_in_raster}
\alias{sim_locked_out_raster}
\alias{sim_zones_pu_raster}
\alias{sim_features}
\alias{sim_zones_features}
\alias{sim_phylogeny}
\alias{get_sim_pu_polygons}
\alias{get_sim_zones_pu_polygons}
\alias{get_sim_pu_points}
\alias{get_sim_pu_lines}
\alias{get_sim_pu_raster}
\alias{get_sim_locked_in_raster}
\alias{get_sim_locked_out_raster}
\alias{get_sim_zones_pu_raster}
\alias{get_sim_features}
\alias{get_sim_zones_features}
\alias{get_sim_phylogeny}
\title{Get simulated conservation planning data}
\format{
\describe{

\item{\code{get_sim_pu_polygons()}}{\code{\link[sf:sf]{sf::st_sf()}} object.}

\item{\code{get_sim_zones_pu_polygons()}}{\code{\link[sf:sf]{sf::st_sf()}} object.}

\item{\code{get_sim_pu_lines()}}{\code{\link[sf:sf]{sf::st_sf()}} object.}

\item{\code{get_sim_pu_points()}}{\code{\link[sf:sf]{sf::st_sf()}} object.}

\item{\code{get_sim_pu_raster()}}{\code{\link[terra:rast]{terra::rast()}} object.}

\item{\code{get_sim_zones_pu_raster()}}{\code{\link[terra:rast]{terra::rast()}} object.}

\item{\code{get_sim_locked_in_raster()}}{\code{\link[terra:rast]{terra::rast()}} object.}

\item{\code{get_sim_locked_out_raster()}}{\code{\link[terra:rast]{terra::rast()}} object.}

\item{\code{get_sim_features()}}{\code{\link[terra:rast]{terra::rast()}} object.}

\item{\code{get_sim_zones_features()}}{\code{\link[=ZonesRaster]{ZonesRaster()}} object.}

\item{\code{get_sim_phylogeny()}}{\code{\link[terra:rast]{terra::rast()}} object.}

}
}
\usage{
get_sim_pu_polygons()

get_sim_zones_pu_polygons()

get_sim_pu_lines()

get_sim_pu_points()

get_sim_pu_raster()

get_sim_locked_in_raster()

get_sim_locked_out_raster()

get_sim_zones_pu_raster()

get_sim_features()

get_sim_zones_features()

get_sim_phylogeny()
}
\description{
A set of functions are available for importing simulated datasets. These
datasets are designed for creating small example spatial prioritizations.
}
\section{Single zone datasets}{


The following functions are provided for generating spatial prioritizations
that only contain a single management zone.

\describe{

\item{\code{get_sim_pu_raster()}}{Import planning unit data that are stored
in raster format.
Here, cell values indicate planning unit cost and missing (\code{NA})
values indicate that a cell is not a planning unit.}

\item{\code{get_sim_locked_in_raster()}}{Import planning unit data
that are stored in raster format.
Here, cell values are binary and indicate if planning units should be
locked in to a solution.}

\item{\code{get_sim_locked_out_raster()}}{Import planning unit data
that are stored in raster format.
Here, cell values are binary and indicate if planning units
should be locked out from a solution.}

\item{\code{get_sim_pu_polygons()}}{Import planning unit data stored in vector
format. Here, planning units are represented using spatial polygons
(e.g., each polygon corresponds to a different management areas).
The data contains columns indicating the expenditure
required for prioritizing each planning unit (\code{"cost"} column), if the
planning units should be selected in the solution (\code{"locked_in"} column),
and if the planning units should never be selected in the solution
(\code{"locked_out"} column).}

\item{\code{get_sim_pu_points()}}{Import planning unit data stored in vector
format. Here, planning units are represented using spatial lines
(e.g., each line corresponds to a different section along a river) .
The attribute table follows the same conventions as for
\code{sim_pu_polygons}.}

\item{\code{get_sim_pu_lines()}}{Import planning unit data stored in vector
format. Here, planning units are represented using spatial points
(e.g., each point corresponds to a different site) .
The attribute table follows the same conventions as for
\code{sim_pu_polygons}.}

\item{\code{get_sim_features()}}{Import feature data stored in raster format.
Here, data describe the spatial distribution of five species.
Each layer corresponds to a different species, and
cell values indicate habitat suitability.}

\item{\code{get_sim_phylogeny()}}{Import phylogenetic tree for the ten species.}

}
}

\section{Multiple zone datasets}{


The following functions are provided for generating spatial prioritizations
that contain multiple management zones.

\describe{

\item{\code{get_sim_zones_pu_raster()}}{Import planning unit data
for multiple management zones that are stored in raster format.
Here, each layer indicates the cost for a different management
zone. Cells with \code{NA} values in a given zone indicate that a
planning unit cannot be allocated to that zone in a solution.
Additionally, cells with \code{NA} values in all layers are not a
planning unit.}

\item{\code{get_sim_zones_pu_polygons()}}{Import planning unit data for
multiple management zones stored in vector format.
Here, planning units are represented using spatial polygons.
The data contains columns indicating the
expenditure required for prioritizing each planning unit under different
management zones (\code{"cost_1"}, \code{"cost_2"}, and \code{"cost_3"} columns), and a
series
of columns indicating the value that each planning unit that should be
assigned in the solution (\code{"locked_1"}, \code{"locked_2"}, \code{"locked_3"}
columns).
In these locked columns, planning units that should not be locked to a
specific value are assigned a missing (\code{NA}) value.}

\item{\code{get_sim_zones_features()}}{Import feature data for multiple
management zones stored in raster format.
Here, data describe the spatial distribution of ten species
under three different management zones.}

}
}

\examples{
# load data
sim_pu_polygons <- get_sim_pu_polygons()
sim_zones_pu_polygons <- get_sim_zones_pu_polygons()
sim_pu_lines <- get_sim_pu_lines()
sim_pu_points <- get_sim_pu_points()
sim_pu_raster <- get_sim_pu_raster()
sim_zones_pu_raster <- get_sim_zones_pu_raster()
sim_locked_in_raster <- get_sim_locked_in_raster()
sim_locked_out_raster <- get_sim_locked_out_raster()
sim_phylogeny <- get_sim_phylogeny()
sim_features <- get_sim_features()
sim_zones_features <- get_sim_zones_features()

# plot raster data
\dontrun{
par(mfrow = c(2, 2))
plot(sim_pu_raster, main = "planning units (raster)", axes = FALSE)
plot(sim_locked_in_raster, main = "locked in units (raster)", axes = FALSE)
plot(sim_locked_out_raster, main = "locked out units (raster)", axes = FALSE)

# plot vector planning unit data
par(mfrow = c(1, 1))
plot(sim_pu_polygons)
plot(sim_pu_lines)
plot(sim_pu_points)

# plot vector planning unit data for multiple management zones
plot(sim_zones_pu_polygons)

# plot phylogeny data
par(mfrow = c(1, 1))
plot(sim_phylogeny, main = "simulated phylogeny")

# plot feature data
par(mfrow = c(1, 1))
plot(sim_features, axes = FALSE)

# plot cost data for multiple management zones
par(mfrow = c(1, 1))
plot(sim_zones_pu_raster, axes = FALSE)

# plot feature data for multiple management zones
plot_names <- paste0(
  "Species ",
   rep(
     seq_len(number_of_zones(sim_zones_features)),
     number_of_features(sim_zones_features)
   ),
   " (zone ",
   rep(
     seq_len(number_of_features(sim_zones_features)),
     each = number_of_zones(sim_zones_features)
   ),
   ")"
)
plot(
  terra::rast(as.list(sim_zones_features)),
   main = plot_names, axes = FALSE
)
}
}
\keyword{datasets}
