% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simData.R
\name{simData}
\alias{simData}
\alias{sim_pu_data}
\alias{sim_features_data}
\alias{sim_dist_features_data}
\alias{sim_threats_data}
\alias{sim_dist_threats_data}
\alias{sim_sensitivity_data}
\alias{sim_boundary_data}
\title{Simulated multi-action planning data}
\format{
\describe{

\item{sim_pu_data}{\link{data.frame}
object.}

\item{sim_features_data}{\link{data.frame}
object.}

\item{sim_dist_features_data}{\link{data.frame}
object.}

\item{sim_threats_data}{\link{data.frame}
object.}

\item{sim_dist_threats_data}{\link{data.frame}
object.}

\item{sim_sensitivity_data}{\link{data.frame}
object.}

\item{sim_boundary_data}{\link{data.frame}
object.}
}
}
\usage{
data(sim_pu_data)

data(sim_features_data)

data(sim_dist_features_data)

data(sim_threats_data)

data(sim_dist_threats_data)

data(sim_sensitivity_data)

data(sim_boundary_data)
}
\description{
Simulated data for making prioritizations.

\describe{

\item{\code{sim_pu_data}}{Planning units are represented as tabular data.}

\item{\code{sim_features_data}}{Features are represented as tabular data.}

\item{\code{sim_dist_features_data}}{The simulated distribution of four features.}

\item{\code{sim_threats_data}}{Threats are represented as tabular data.}

\item{\code{sim_dist_threats_data}}{The simulated threats of two threats.}

\item{\code{sim_sensitivity_data}}{Sensitivity of features to threats as tabular data.}

\item{\code{sim_boundary_data}}{Boundary data between one hundred planning units.}

}
}
\examples{
\dontrun{
# load data
data(sim_pu_data, sim_features_data, sim_dist_features_data,
sim_threats_data, sim_dist_threats_data, sim_sensitivity_data,
sim_boundary_data)

# plot examples
library(raster)
r <- raster::raster(ncol=10, nrow=10, xmn=0, xmx=10, ymn=0, ymx=10)

# plot cost of pu's
values(r) <- sim_pu_data$monitoring_cost
plot(r)

# plot feature distribution of feature 1
features <- tidyr::spread(data = sim_dist_features_data, key = feature, value = amount, fill = 0)
values(r) <- features$'1'
plot(r)
}
}
\keyword{datasets}
