% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_mimic.R
\name{spec_mimic}
\alias{spec_mimic}
\title{Function to mimic the power spectrum of an observed time series.}
\usage{
spec_mimic(X, Y = NULL, gamma = 1)
}
\arguments{
\item{X}{numeric vector.}

\item{Y}{if not NULL, a numeric vector.}

\item{gamma}{power of the 1/f noise; used only if Y is NULL.}
}
\description{
This function rearranges one vector, X, to mimic the spectrum of another
vector, Y.
}
\details{
If Y is NULL, this function will use [one_over_f()] to generate a random
series with power = gamma.
}
\examples{
N = 50
set.seed(1)
X1 <- runif(N)
Y <- one_over_f(gamma=2, N=N)
X2 <- spec_mimic(X1, Y)
series <- cbind(X1, Y, X2)
matplot(1:50, series, type='l')
legend("bottomright", legend=colnames(series), col=1:3, lty=1:3)

}
\references{
J. M. Halley. Ecology, evolution and 1/f-noise. Trends in
Ecology & Evolution, 11:33-37, 1996. O. L. Petchey, A. Gonzalez, and H. B.
Wilson. Effects on population persistence: the interaction between
environmental noise colour, intra-specific competition and space.
Proceedings of the Royal Society of London Series B, 264:1841-1847, 1997. J.
E. Cohen, C. M. Newman, A. E. Cohen, O. L. Petchey, and A. Gonzalez.
Spectral mimicry: a method of synthesizing matching time series with
different Fourier spectra. Circuits, Systems and Signal Processing,
18:431-442, 1999.
}
\seealso{
[one_over_f()] to generate 1/f noise; [plot_f()] to plot the time
series and the spectrogram of the series.
}
\author{
Hank Stevens
}
\keyword{1/f}
\keyword{color}
\keyword{mimicry}
\keyword{noise}
\keyword{spectra}
