% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIRd.R
\name{SIRd}
\alias{SIRd}
\title{The S-I-R Epidemilogical Disease Model}
\usage{
SIRd(t, y, p)
}
\arguments{
\item{t}{times points for which values will be returned}

\item{y}{the vector of disease states of hosts (S, I, R)}

\item{p}{a vector of parameters}
}
\value{
Returns of list of one component (required by \code{ode}).
}
\description{
The S-I-R epidemilogical disease model with density-dependent transmission, for use with \code{ode} in the
\code{deSolve} package.
}
\details{
The user does not put these directly into this function, but rather uses
\code{ode} in the \code{deSolve} package.
}
\examples{

N <- 10^3; I <- R <- 1; S <- N - I - R
parms <- c(B=.01, g=4)
months <- seq(0, 3, by=0.01)
require(deSolve)
SIR.out <- data.frame( ode(c(S,I,R), months, SIRd, parms) )
matplot(months, SIR.out[,-1], type='l')
legend('right', c('R', 'I', 'S'), lty=3:1, col=3:1, bty='n')

}
\references{
Ellner, S.P. and Guckenheimer, J. (2006) \emph{Dynamic Models in
Biology}, Princeton University Press.

Kermack, W.O. and McCormick, W.G. (1927) A contribution to the mathematical
theory of epidemics. \emph{Proceedings of the Royal Society, Series A},
\bold{115}, 700--721.

Stevens, M.H.H. (2009) \emph{A Primer of Ecology with R}, Use R! Series.
Springer.
}
\seealso{
\code{\link{ross}}, \code{\link{SIRf}}, \code{\link{SIRbd}}
}
\author{
Hank Stevens <Hank.Stevens@miamioh.edu>
}
\keyword{methods}
