% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde.prevR.r
\name{kde,prevR-method}
\alias{kde,prevR-method}
\alias{kde-methods}
\alias{kde}
\title{Kernel density estimation for prevR object.}
\usage{
\S4method{kde}{prevR}(
  object,
  N = NULL,
  R = NULL,
  weighted = TRUE,
  risk.ratio = FALSE,
  keep.details = FALSE,
  nb.cells = 100,
  cell.size = NULL,
  progression = TRUE,
  short.names = FALSE
)
}
\arguments{
\item{object}{object of class \linkS4class{prevR}.}

\item{N}{integer or list of integers corresponding to the rings to use.}

\item{R}{integer or list of integers corresponding to the rings to use.}

\item{weighted}{use weighted data (\code{TRUE}, \code{FALSE} or \code{2})?}

\item{risk.ratio}{calculate a relative risks surface instead of a
prevalence surface (\code{TRUE}, \code{FALSE} or \code{2})?}

\item{keep.details}{return surface of positive cases and surface of
observed cases?}

\item{nb.cells}{number of cells on the longest side of the studied area
(unused if \code{cell.size} is defined).}

\item{cell.size}{size of each cell (in the unit of the projection).}

\item{progression}{show a progress bar?}

\item{short.names}{should names of the output be short?}
}
\value{
Object of class \link[sf:sf]{sf::sf}.
Surfaces are named according to the name of the corresponding N and R
(for example: \emph{k.prev.N300.RInf}). If \code{short.names} is \code{TRUE} and
if there is only one combination of couples (N, R), variable names will not
be suffixed by the value of N and R.

Estimated variables are (depending on the function parameters) :\itemize{
\item "k.pos" unweighted intensity surface of positive cases.
\item "k.obs" unweighted intensity surface of observed cases.
\item "k.prev" unweighted surface of prevalence (k.pos/k.obs).
\item "k.case" unweighted density surface of positive cases.
\item "k.control" unweighted density surface of observed cases.
\item "k.rr" unweighted surface of relative risks (k.case/k.control).
\item "k.wpos" weighted intensity surface of positive cases.
\item "k.wobs" weighted intensity surface of observed cases.
\item "k.wprev" weighted surface of prevalence (k.wpos/k.wobs).
\item "k.wcase" weighted density surface of positive cases.
\item "k.wcontrol" weighted density surface of observed cases.
\item "k.wrr" weighted surface of relative risks (k.wcase/k.wcontrol).
}
}
\description{
This function allows to calculate a prevalence surface (ratio of two
intensity surfaces) and/or a relative risks surface (ratio of two density
surfaces) using gaussian kernel estimators with adaptative bandwidths of
equal number of observations or equal radius.
}
\details{
This function calculates a prevalence surface as the ratio of the
intensity surface (expressed in cases per surface unit) of positive cases
on the intensity surface of observed cases and could also calculate a
relative risks surface corresponding to the ratio of the density surface
(whose integral has been normalized to one) of positive cases on density
surface of observed cases.

This method is a variant of the nearest neighbor technique. Surfaces are
estimated using gaussian kernel estimators with adaptative bandwidths,
bandwidth size being determined by a minimum number of
observations in the neighborhood (see \code{\link[=rings]{rings()}} for more details).
Fixed bandwidths could also be used. More precisely, the bandwidth used is
half the radius of rings of equal number of observations or equal radius
(parameters \code{N} and \code{R}) calculated by the' function \code{\link[=rings]{rings()}}.

See references for a detailed explanation of the implemented methodology.

\code{N} and \code{R} determine the rings to use for the estimation. If they are not
defined, surfaces will be estimated for each available couples (N,R)
available in \code{object}. Several estimations could be
simultaneously calculated if several values of N and R are defined.

A suggested value of N could be computed with \code{\link[=Noptim]{Noptim()}}.
}
\note{
Results could be plotted with \code{\link[sf:plot]{sf::plot()}} or with \pkg{ggplot2}
using \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}. See examples.

\pkg{prevR} provides several continuous color palettes
(see \link{prevR.colors}).

Results could be turned into a \pkg{stars} raster using
\code{\link[stars:st_rasterize]{stars::st_rasterize()}}.

To export to ASCII grid, rasterize the results with \code{\link[stars:st_rasterize]{stars::st_rasterize()}},
convert to \code{SpatRast} with \code{\link[terra:rast]{terra::rast()}}, extract the desired layer with
\verb{[[]]} and then use \code{terra::writeRaster()}. See examples.

See the package \pkg{sparr} for another methodology to estimate relative
risks surfaces, adapted for other kind of data than Demographic and
Health Surveys (DHS).
}
\examples{
\dontrun{
dhs <- rings(fdhs, N = c(100, 200, 300, 400, 500))

prev.N300 <- kde(dhs, N = 300, nb.cells = 200)

plot(prev.N300, lty = 0)

library(ggplot2)
ggplot(prev.N300) +
  aes(fill = k.wprev.N300.RInf) +
  geom_sf(colour = "transparent") +
  scale_fill_gradientn(colors = prevR.colors.red()) +
  theme_prevR_light()

# Export k.wprev.N300.RInf surface in ASCII Grid
r <- terra::rast(stars::st_rasterize(prev.N300))
# writeRaster(r[[2]], "kprev.N300.asc")
}

}
\references{
Larmarange Joseph, Vallo Roselyne, Yaro Seydou, Msellati Philippe
and Meda Nicolas (2011) "Methods for mapping regional trends of HIV
prevalence from Demographic and Health Surveys (DHS)",
\emph{Cybergeo: European Journal of Geography}, no 558,
\url{https://journals.openedition.org/cybergeo/24606},
DOI: 10.4000/cybergeo.24606.
}
\seealso{
\code{\link[KernSmooth:bkde2D]{KernSmooth::bkde2D()}}, \code{\link[=rings]{rings()}}, \code{\link[=Noptim]{Noptim()}}.
}
\keyword{smooth}
\keyword{spatial}
