% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reeh_ptp.R
\name{calculate_reeh_2019_clinical_ptp}
\alias{calculate_reeh_2019_clinical_ptp}
\title{Calculate 2019 Reeh Clinical PTP for obstructive CAD}
\usage{
calculate_reeh_2019_clinical_ptp(
  age,
  sex,
  symptom_type,
  have_dyslipidemia,
  have_family_history,
  have_diabetes,
  label_sex_male = c("male"),
  label_sex_female = c("female"),
  label_sex_unknown = c(NA, NaN),
  label_symptom_type_typical = c("typical"),
  label_symptom_type_atypical = c("atypical"),
  label_symptom_type_nonanginal = c("nonanginal"),
  label_symptom_type_dyspnoea = c("dyspnoea"),
  label_symptom_type_unknown = c(NA, NaN),
  label_have_dyslipidemia_no = c("no"),
  label_have_dyslipidemia_yes = c("yes"),
  label_have_dyslipidemia_unknown = c(NA, NaN),
  label_have_family_history_no = c("no"),
  label_have_family_history_yes = c("yes"),
  label_have_family_history_unknown = c(NA, NaN),
  label_have_diabetes_no = c("no"),
  label_have_diabetes_yes = c("yes"),
  label_have_diabetes_unknown = c(NA, NaN)
)
}
\arguments{
\item{age}{Input numeric value to indicate the age of the patient in years.}

\item{sex}{The value of variable in the parameters \code{label_sex_male},
\code{label_sex_female} and \code{label_sex_unknown}.}

\item{symptom_type}{Input characters (typical, atypical, nonanginal, dyspnoea)
to indicate the symptom characteristics of the patient.
\itemize{
  \item typical stands for the patient having typical chest pain.
  \item atypical stands for the patient having atypical chest pain.
  \item nonanginal stands for the patient having nonanginal or non-specific chest pain.
  \item dyspnoea stands for the patient having dyspnoea.
}}

\item{have_dyslipidemia}{The value of variable in the parameters
\code{label_have_dyslipidemia_no}, \code{label_have_dyslipidemia_yes}
and \code{label_have_dyslipidemia_unknown}.}

\item{have_family_history}{The value of variable in the parameters
\code{label_have_family_history_no}, \code{label_have_family_history_yes}
and \code{label_have_family_history_unknown}.}

\item{have_diabetes}{The value of variable in the parameters
\code{label_have_diabetes_no}, \code{label_have_diabetes_yes}
and \code{label_have_diabetes_unknown}.}

\item{label_sex_male}{Label(s) for definition(s) of male sex.
Default: \code{c("male")}}

\item{label_sex_female}{Label(s) for definition(s) of female sex.
Default: \code{c("female")}}

\item{label_sex_unknown}{Label(s) for definition(s) of missing sex.
Default: \code{c(NA, NaN)}}

\item{label_symptom_type_typical}{Label(s) for patient having typical chest pain.
Default: \code{c("typical")}}

\item{label_symptom_type_atypical}{Label(s) for patient having atypical chest pain.
Default: \code{c("atypical")}}

\item{label_symptom_type_nonanginal}{Label(s) for patient having nonanginal
or non-specific chest pain.
Default: \code{c("nonanginal")}}

\item{label_symptom_type_dyspnoea}{Label(s) for patient having dyspnoea.
Default: \code{c("dyspnoea")}}

\item{label_symptom_type_unknown}{Label(s) for patient having unknown symptoms.
Default: \code{c(NA, NaN)}}

\item{label_have_dyslipidemia_no}{Label(s) for patient with no dyslipidemia.
Default: \code{c("no")}}

\item{label_have_dyslipidemia_yes}{Label(s) for patient having dyslipidemia.
Default: \code{c("yes")}}

\item{label_have_dyslipidemia_unknown}{Label(s) for patient
having unknown dyslipidemia.
Default: \code{c(NA, NaN)}}

\item{label_have_family_history_no}{Label(s) for patient with no family history of CAD.
Default: \code{c("no")}}

\item{label_have_family_history_yes}{Label(s) for patient having family history of CAD.
Default: \code{c("yes")}}

\item{label_have_family_history_unknown}{Label(s) for patient
having unknown family history of CAD.
Default: \code{c(NA, NaN)}}

\item{label_have_diabetes_no}{Label(s) for patient with no diabetes.
Default: \code{c("no")}}

\item{label_have_diabetes_yes}{Label(s) for patient having diabetes.
Default: \code{c("yes")}}

\item{label_have_diabetes_unknown}{Label(s) for patient
having unknown diabetes.
Default: \code{c(NA, NaN)}}
}
\value{
A numeric value representing the patient's PTP for obstructive CAD
based on the 2019 Reeh et. al. clinical model.
}
\description{
This function returns a patient's
pre-test probability (PTP) of obstructive
coronary artery disease based on the
2019 Reeh et. al. clinical model.
}
\details{
The predictive model is based on 3903
patients free of CAD and heart failure and suspected of angina, who were referred
to a single, large, urban university hospital for assessment in 2012–15.
}
\examples{
# 40 year old female with typical chest pain
calculate_reeh_2019_clinical_ptp(
    age = 40,
    sex = "female",
    symptom_type = "typical",
    have_dyslipidemia = "no",
    have_family_history = "no",
    have_diabetes = "no"
)
}
