% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pref_summaries.R
\name{pref_cov}
\alias{pref_cov}
\title{Covariance matrix for preferences, calculated using the rankings matrix.}
\usage{
pref_cov(x, preferences_col = NULL, frequency_col = NULL, ...)
}
\arguments{
\item{x}{A vector of preferences, or a tibble with a column of preferences.}

\item{preferences_col}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> When \code{x} is a
\code{tibble}, the column containing the preferences.}

\item{frequency_col}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> When \code{x} is a
\code{tibble}, the column containing the frequency of the preferences. If not
provided, each row is considered to be observed a single time.}

\item{...}{Extra arguments to be passed to \code{stats::cov.wt}.}
}
\value{
A covariance matrix containing covariances for the ranks assigned to
item pairs.
}
\description{
Covariance matrix for preferences, calculated using the rankings matrix.
}
\examples{
# Simple covariance on a vector of preferences
prefs <- preferences(c("a > b > c", "b > c > a", "c > a > b"))
pref_cov(prefs)

# Weighted covariance by frequency
df <- tibble::tibble(
  prefs = preferences(c("a > b > c", "b > c > a")),
  freq = c(3, 2)
)
pref_cov(df, preferences_col = prefs, frequency_col = freq)
}
