% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson-pref.r
\name{overall_sample_size_pois}
\alias{overall_sample_size_pois}
\title{Overall Sample Size Poisson Distribution}
\usage{
overall_sample_size_pois(
  power,
  phi,
  lambda11,
  lambda22,
  lambda1,
  lambda2,
  alpha = 0.05,
  theta = 0.5,
  xi = 1,
  nstrata = 1
)
}
\arguments{
\item{power}{desired study power. Should be numeric value between 0 and 1.}

\item{phi}{the proportion of patients preferring treatment 1. Should be
numeric value between 0 and 1. If study is stratified, should be
vector with length equal to the number of strata in the study.}

\item{lambda11}{response mean of patients choosing to receive treatment 1 
in the choice arm. Should be numeric value larger than 0. If
study is stratified, should be vector with length equal to the 
number of strata in the study.}

\item{lambda22}{response mean of patients choosing to receive treatment 2 
in the choice arm. Should be numeric value larger than 0. If
study is stratified, should be vector with length equal to the 
number of strata in the study.}

\item{lambda1}{response mean of patients randomized to receive treatment 1 
in the random arm. Should be numeric value larger than 0. If
study is stratified, should be vector with length equal to the 
number of strata in the study.}

\item{lambda2}{response mean of patients randomized to receive treatment 2 
in the random arm. Should be numeric value larger than 0. If
study is stratified, should be vector with length equal to the 
number of strata in the study.}

\item{alpha}{desired type I error rate.}

\item{theta}{proportion of patients assigned to choice arm in the initial
randomization. Should be numeric value between
0 and 1 (default=0.5).}

\item{xi}{a numeric vector of the proportion of patients in each stratum. 
Length of vector should equal the number of strata in the study and 
sum of vector should be 1. All vector elements should be numeric 
values between 0 and 1. Default is 1 (i.e. unstratified design).}

\item{nstrata}{number of strata. Default is 1 (i.e. unstratified design).}
}
\description{
Calculates the sample size required to detect a given set of effects 
in a two-stage randomized clinical trial. Returns the largest
of the required sample sizes for a given set of treatment, selection, and 
preference effects.
}
\examples{
# Unstratified
overall_sample_size_pois(power = 0.8, phi = 0.6, lambda11 = 0.6, 
                         lambda22 = 0.7, lambda1 = 0.4, lambda2 = 0.6)
# Stratified
overall_sample_size_pois(power = 0.8, phi = c(0.6, 0.5), 
                         lambda11 = c(0.6, 0.7), lambda22 = c(0.7,0.7), 
                         lambda1 = c(0.4, 0.6), lambda2 = c(0.6, 0.6), 
                         xi = c(0.5, 0.5), nstrata = 2)
}
