#' srr_stats
#'
#' All of the following standards initially have `@srrstatsTODO` tags.
#' These may be moved at any time to any other locations in your code.
#' Once addressed, please modify the tag from `@srrstatsTODO` to `@srrstats`,
#' or `@srrstatsNA`, ensuring that references to every one of the following
#' standards remain somewhere within your code.
#' (These comments may be deleted at any time.)
#'
#' @srrstatsVerbose TRUE
#'
#' @noRd
NULL

#' NA_standards
#'
#' @srrstatsNA {G1.6} No performance claims are made.
#' @srrstatsNA {G2.2} No formula applied and all inputs either a single value or
#'  vector (and checked).
#' @srrstatsNA {G2.3} No character inputs.
#' @srrstatsNA {G2.3a} No applicable areas.
#' @srrstatsNA {G2.3b} No character inputs.
#' @srrstatsNA {G2.4} No input data that requires conversion.
#' @srrstatsNA {G2.4a} No input data that requires conversion.
#' @srrstatsNA {G2.4b} No input data that requires conversion.
#' @srrstatsNA {G2.4c} No input data that requires conversion.
#' @srrstatsNA {G2.4e} No conversion from factor.
#' @srrstatsNA {G2.5} No inputs are expected to be factors.
#' @srrstatsNA {G2.7} No tabular inputs used.
#' @srrstatsNA {G2.9} No type conversion of this nature applied.
#' @srrstatsNA {G2.10} No tabular inputs used.
#' @srrstatsNA {G2.12} No tabular inputs used.
#' @srrstatsNA {G2.14} Missing or NA values will throw errors if passed.
#' Inputs are required to perform simulations (except for sample_size, which
#' will revert to a calculated sample size using a power calculation).
#' @srrstatsNA {G2.14b} Inputs are required.
#' @srrstatsNA {G2.14c} Inputs are required.
#' @srrstatsNA {G3.1} No calculations of covariance are performed.
#' @srrstatsNA {G3.1a} No calculations of covariance are performed.
#' @srrstatsNA {G4.0} No writing of outputs to files incorporated
#' within package.
#' @srrstatsNA {G5.0} Input data not used.
#' @srrstatsNA {G5.1} All data are generated by the package from simulation
#' inputs. Code is given for all examples.
#' @srrstatsNA {G5.4b} No existing methods but comparisons are made to
#' "ground truth" input values for simulation of prediction model
#' (see test-simulated-calibrated-model.R).
#' @srrstatsNA {G5.7} No ground truth parameters for which to test to assess
#' convergence as data increases.
#' @srrstatsNA {G5.9a} Not applicable to this package's process.
#' @srrstatsNA {G5.10} No extended tests.
#' @srrstatsNA {G5.11a} No assets are downloaded. Only assets used in tests are
#' either made within test or provided in 'tests/testthat/fixtures/'.
#' @srrstatsNA {G5.12} No extended tests included.
#'
#' @srrstatsNA {EA2.4} No tables are given by user.
#' @srrstatsNA {EA2.5} No tables are given by user but generated tables
#' (within package from vector inputs) are indexed as described by EA2.2.
#' @srrstatsNA {EA5.6} There are currently no dynamic visualisations in this
#' package.
#' @srrstatsNA {EA6.0e} There are no single-valued objects returned.
#'
#' Any non-applicable standards can have their tags changed from `@srrstatsTODO`
#' to `@srrstatsNA`, and placed together in this block, along with explanations
#' for why each of these standards have been deemed not applicable.
#' (These comments may also be deleted at any time.)
#' @noRd
NULL
