% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose_expressions.R
\name{diagnose_expressions}
\alias{diagnose_expressions}
\alias{debug-markers}
\title{Diagnose expressions and substitute debug markers}
\usage{
diagnose_expressions(..., .env)
}
\arguments{
\item{...}{expressions to diagnose}

\item{.env}{(advanced) the environment where the diagnosis should be performed}
}
\value{
a data frame with diagnostic information
}
\description{
Assertions in the \code{precondition} package support debug markers to provide
user-friendly assertion failure diagnosis. The low-level diagnostic
machinery is implemented by \code{diagnose_expressions()}. Advanced users can
make use of this function in their own code or when implementing custom
assertion helpers (see \code{\link[=diagnose_assertion_failure]{diagnose_assertion_failure()}}).

Use single curly braces \code{{x}} to mark expressions of interest and make them
appear as separate entries in the diagnostic output. Use double curly braces
\code{{{x}}} to perform checks on behalf of a parent function and display
diagnostics in the context of the parent.
}
\details{
\code{diagnose_expressions()} supports two kinds of debug markers. Both rely on
wrapping expressions in one or more curly braces \code{{}}.
\itemize{
\item wrapping an expression in curly braces (e.g. \code{{x} > 0}) means that the this
expression is of particular interest and should be diagnosed separately.
The braces will be removed from the diagnostic output and the wrapped
expression will be added as a separate entry in the diagnostic table
(note: \code{diagnose_expressions({x} > 0)} is equivalent to \code{debug_expressions (x > 0, x)}).
\item wrapping a function argument in two curly braces (e.g. `{{arg}} > 0) means
that the argument is being been forwarded from a parent function. This
concept of forwarding is borrowed from tidyverse's
\link[rlang:embrace-operator]{rlang::embrace-operator}. A forwarded argument will be replaced by the
original caller expression in the diagnostic output.
}

\code{diagnose_expressions()} returns a data frame with one row per diagnosed
expression(either supplied as an argument or marked via \code{{}}) and three
columns. The column \code{expr} is a list of diagnosed expressions, with debug
markers processed and substituted. The column \code{eval_result} is a list of
evaluated results for each diagnosed expressions. The column \code{is_error} is a
logical vector where value of \code{TRUE} indicates that an error occurred when
evaluating the respective expression. In this case the corresponding value
of \code{eval_result} will capture the error condition.

Note that expressions or their parts might be evaluated more then once during
diagnosis. Side effects in diagnosed expressions can lead to unexpected
behavior.
}
\examples{

x <- 10
diagnose_expressions({x} > 0, {x} > 15)

helper <- function(arg) {
   cat(sprintf("`arg` is forwarded `\%s`\n", forwarded_arg_label(arg)))
   diagnose_expressions({{{arg}}} > 0)
}
fun <- function(x) {
  helper(x)
}
fun(10)
}
