% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_precisely.R
\name{map_precisely}
\alias{map_precisely}
\title{Calculate with precisely functions across values}
\usage{
map_precisely(.f, ...)
}
\arguments{
\item{.f}{a function in precisely}

\item{...}{arguments passed to \code{.f}. All possible combinations of argument
values are given to the function.}
}
\value{
a tibble
}
\description{
\code{map_precisely()} is a wrapper around \code{\link[tidyr:expand]{tidyr::crossing()}} and
\code{\link[purrr:map2]{purrr::pmap_dfr()}} to give a set of values to any of the calculation
functions in precisely. All possible combinations of the values are passed to
the function, returning a tibble where each row is the result for each
combination.
}
\examples{
map_precisely(
  n_risk_difference,
  precision = seq(from = .02, to = .20, by = .005),
  exposed = c(.2, .4),
  unexposed = c(.1, .3),
  group_ratio = 1
)

}
