% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualize_correlations}
\alias{visualize_correlations}
\title{Visualize the correlation matrix}
\usage{
visualize_correlations(
  df,
  color_value_positive = "#08306B",
  color_value_negative = "#8b0000",
  color_text = "#FFFFFF",
  include_missings = FALSE,
  ...
)
}
\arguments{
\item{df}{data.frame containing columns for x and y}

\item{color_value_positive}{color used for upper limit of gradient (high positive correlation)}

\item{color_value_negative}{color used for lower limit of gradient (high negative correlation)}

\item{color_text}{color used for text, best to pick high contrast with \code{color_value_high}}

\item{include_missings}{bool, whether to include the variables without correlation values in the plot}

\item{...}{arguments to pass to \code{stats::cor()}}
}
\value{
a ggplot object, a heatmap visualization
}
\description{
Visualize the correlation matrix
}
\examples{
visualize_correlations(iris)
}
