% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{ecls_data}
\alias{ecls_data}
\title{Early Childhood Longitudinal Study Dataset}
\format{
A data frame with 9,101 observations, including:
\describe{
\item{Child_ID}{Unique identifier for each child in the dataset.}
\item{School_ID}{Identifier for each school in the dataset.}
\item{Math_Score}{Continuous variable representing the consolidated math proficiency score.}
\item{Income}{Household income, categorized into 18 ordinal levels, from $5,000 or less to $200,000 or more. Treated as a continuous variable in the analysis.}
\item{Child_Sex}{Binary variable indicating the gender of each student.}
}
}
\source{
Available at the following website: \url{https://nces.ed.gov/ecls/}.
}
\usage{
data(ecls_data)
}
\description{
The Early Childhood Longitudinal Study (ECLS) dataset tracks more than 18,000 children
from kindergarten through fifth grade, providing comprehensive student-level information. See Tourangeau et al. (2015) for details.
}
\details{
The dataset includes fifth-grade cross-sectional data, focusing on students' mathematical
assessment scores as the primary outcome measure. The mathematical assessment covers 18 topics
such as number sense, properties, operations, measurement, geometry, data analysis, and algebra.
These items evaluate students' competencies in conceptual knowledge, procedural knowledge, and
problem-solving, consolidated into a single "Math score." A higher score indicates greater proficiency.
The primary predictors are household income and gender, where gender is a categorical variable.
Household income is categorized into 18 ordinal levels, ranging from $5,000 or less (level 1) to
$200,000 or more (level 18). In the analysis, the income variable is treated as a continuous variable.
The dataset removes all records with missing values and consists of 9,101 complete observations from 2,275 schools.
}
\examples{
data(ecls_data)
formula_FE <- as.formula("Math_Score ~ Income + id(School_ID) + Child_Sex")
fit_FE <- linear_fe(formula = formula_FE, data = ecls_data)

formula_RE <- as.formula("Math_Score ~ Income + (1|School_ID) + Child_Sex")
fit_RE <- linear_re(formula = formula_RE, data = ecls_data)
}
\references{
Tourangeau, K., Nord, C., Lê, T., Sorongon, A. G., Hagedorn, M. C., Daly, P.,
& Najarian, M. (2015). Early Childhood Longitudinal Study, Kindergarten Class of
2010-11 (ECLS-K:2011): User’s manual for the ECLS-K:2011 kindergarten data file
and electronic codebook, public version (NCES 2015-074). National Center for
Education Statistics.
\cr
}
\keyword{datasets}
