% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_cambodia.R
\docType{data}
\name{ppiKHM2023}
\alias{ppiKHM2023}
\title{Poverty Probability Index (PPI) lookup table for Cambodia for 2023}
\format{
A data frame with 14 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nl100}}{National poverty line (100\%)}
\item{\code{nl150}}{National poverty line (150\%)}
\item{\code{nl200}}{National poverty line (200\%)}
\item{\code{ppp550}}{Below $3.20 per day purchasing power parity (2011)}
\item{\code{ppp800}}{Below $3.20 per day purchasing power parity (2011)}
\item{\code{ppp1100}}{Below $11.00 per day purchasing power parity (2011)}
\item{\code{ppp1500}}{Below $15.00 per day purchasing power parity (2011)}
\item{\code{ppp2170}}{Below $21.70 per day purchasing power parity (2011)}
\item{\code{ppp685}}{Below $6.85 per day purchasing power parity (2017)}
\item{\code{percentile20}}{Below 20th percentile poverty line}
\item{\code{percentile40}}{Below 40th percentile poverty line}
\item{\code{percentile60}}{Below 60th percentile poverty line}
\item{\code{percentile80}}{Below 80th percentile poverty line}
}
}
\source{
\url{https://www.povertyindex.org}
}
\usage{
ppiKHM2023
}
\description{
Poverty Probability Index (PPI) lookup table for Cambodia for 2023
}
\examples{
  # Access Cambodia PPI table
  ppiKHM2023

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiKHM2023[ppiKHM2023$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiKHM2023, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the national
  # poverty line definition
  ppiScore <- 50
  ppiKHM2023[ppiKHM2023$score == ppiScore, "nl100"]

}
\keyword{datasets}
