% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmpp_latent.R
\name{mmpp_latent}
\alias{mmpp_latent}
\title{Estimate Latent process of MMPP}
\usage{
mmpp_latent(params = list(lambda0, c, Q), events, zt, start = 0)
}
\arguments{
\item{params}{parameters of the MMPP, an MMPP object}

\item{events}{events (not including 0, but assumes start at 0)}

\item{zt}{inferred latent state of events}
}
\value{
list of the states of the Markov process (z.hat)
and the times of the transitions between these times (x.hat).
}
\description{
Estimate Latent process of MMPP
}
\examples{
Q <- matrix(c(-0.04, 0.04, 0.02, -0.02), ncol = 2, byrow = TRUE)
mmpp_obj <- pp_mmpp(Q, delta = c(1 / 3, 2 / 3), lambda0 = 1, c = 1)
ppdiag:::mmpp_latent(params = mmpp_obj, events = c(1, 2, 3), zt = c(2, 1, 1))
}
\keyword{internal}
