% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{postPPtheta}
\alias{postPPtheta}
\alias{postPPthetaHPD}
\title{Marginal posterior distribution of effect size}
\usage{
postPPtheta(
  theta,
  tr,
  sr,
  to,
  so,
  x = 1,
  y = 1,
  alpha = NA,
  m = 0,
  v = Inf,
  hypergeo = FALSE,
  ...
)

postPPthetaHPD(
  level,
  tr,
  sr,
  to,
  so,
  x = 1,
  y = 1,
  alpha = NA,
  m = 0,
  v = Inf,
  thetaRange = tr + c(-1, 1) * stats::qnorm(p = (1 + level)/2) * sr * 3,
  quantileRange = c((1 - level) * 0.2, (1 - level) * 0.8),
  ...
)
}
\arguments{
\item{theta}{Effect size. Can be a vector.}

\item{tr}{Effect estimate of the replication study.}

\item{sr}{Standard error of the replication effect estimate.}

\item{to}{Effect estimate of the original study.}

\item{so}{Standard error of the replication effect estimate.}

\item{x}{Number of successes parameter for beta prior of power parameter
\eqn{\alpha}{alpha}. Defaults to \code{1}. Is only taken into account
when \code{alpha = NA}.}

\item{y}{Number of failures parameter for beta prior of power parameter
\eqn{\alpha}{alpha}. Defaults to \code{1}. Is only taken into account
when \code{alpha = NA}.}

\item{alpha}{Power parameter. Can be set to a number between 0 and 1.
Defaults to \code{NA} (a beta prior on the power parameter).}

\item{m}{Mean parameter of initial normal prior for \eqn{\theta}{theta}.
Defaults to \code{0}.}

\item{v}{Variance parameter of initial normal prior for \eqn{\theta}{theta}.
Defaults to \code{Inf} (uniform prior).}

\item{hypergeo}{Logical indicating whether for uniform priors, the marginal
posterior should be computed with the hypergeometric function. Defaults
to \code{FALSE} (using numerical integration instead).}

\item{...}{Additional arguments passed to \code{stats::integrate} or
\code{hypergeo::genhypergeo} (depending on the \code{hypergeo} argument).}

\item{level}{Credibility level of the highest posterior density interval.
Defaults to \code{0.95}.}

\item{thetaRange}{The numerical search range for the effect size. Defaults to
the \code{level*100}\% confidence inteval range inflated by a factor of
three. We recommend changing this argument only if there are numerical
problems in calculating the HPD interval.}

\item{quantileRange}{The numerical search range for the lower posterior
quantile of the HPD interval. Defaults to the range between \code{(1 -
level)*0.2} and \code{(1 - level)*0.8}. We recommend changing this
argument only if there are numerical problems in calculating the HPD
interval.}
}
\value{
\code{postPPtheta} returns the marginal posterior density of the
    effect size.

\code{postPPthetaHPD} returns the highest marginal posterior density
    interval of the effect size (this may take a while).
}
\description{
These functions compute the marginal posterior of the effect
    size \eqn{\theta}{theta}. A power prior for \eqn{\theta}{theta} is
    constructed by updating an initial normal prior \eqn{\theta \sim
    \mathrm{N}(\code{m}, \code{v})}{theta ~ N(m, v)} with likelihood of the
    original data raised to the power of \eqn{\alpha}{alpha}. The power
    parameter \eqn{\alpha}{alpha} can either be fixed to some value between 0
    and 1 or it can have a beta prior distribution \eqn{\alpha \sim
    \mbox{Beta}(\code{x}, \code{y})}{alpha ~ Beta(x,y)}.
}
\examples{
theta <- seq(0, 0.6, 0.001)
margpostdens <- postPPtheta(theta = theta, tr = 0.1, to = 0.2, sr = 0.05, so = 0.05)
plot(theta, margpostdens, type = "l", xlab = bquote("Effect size" ~ theta),
     ylab = "Marginal posterior density", las = 1)
}
\seealso{
\code{\link{postPP}}, \code{\link{postPPalpha}}, \code{\link{plotPP}}
}
\author{
Samuel Pawel
}
