% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unequal_unordered.R
\name{unequal.unordered}
\alias{unequal.unordered}
\title{Subsidiary PowerLATE Function}
\usage{
unequal.unordered(
  power = NULL,
  sig.level = NULL,
  pi = NULL,
  kappa = NULL,
  N = NULL,
  pZ = NULL
)
}
\arguments{
\item{power}{power of test (1 minus Type II error probability)}

\item{sig.level}{significance level (Type I error probability).}

\item{pi}{compliance rate. Equivalently, average causal effect of Z on D.}

\item{kappa}{effect size}

\item{N}{total number of observations}

\item{pZ}{probability of being assigned to treatment.}
}
\value{
A vector of values for one in \{kappa, N, power\} that is not supplied by the user.
}
\description{
Subsidiary function to perform power calculation under unequal assignment probability and without ordered mean assumption.
}
\note{
This function is called internally and thus should not be used directly.
}
\references{
Bansak, K. (2020). A Generalized Approach to Power Analysis for Local Average Treatment Effects. Statistical Science, 35(2), 254-271.
}
\seealso{
\code{\link{equal.unordered}}, \code{\link{equal.ordered}}, \code{\link{unequal.ordered}}.
}
\author{
Kirk Bansak and Eddie Yang
}
