% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerCompRisk.R
\name{powerCompRisk}
\alias{powerCompRisk}
\title{Power Analysis Tool for Joint Testing Hazards with Competing Risks Data.}
\usage{
powerCompRisk(alpha, beta, lambda_11, RR, HR_1, HR_all, attrition, r, f, a1)
}
\arguments{
\item{alpha}{Type I error.}

\item{beta}{Type II error.}

\item{lambda_11}{Cause-1 cause-specific hazard in group 1.}

\item{RR}{Relative risk of cause-1 failure versus the any-cause failure in group 1.}

\item{HR_1}{Pre-specified cause-1 cause-specific hazard ratio between groups 1 and 2.}

\item{HR_all}{Pre-specified any-cause hazard ratio between groups 1 and 2.}

\item{attrition}{Attrition rate due to lost to follow-up.}

\item{r}{Length of patient accrual period.}

\item{f}{Maximum follow-up period.}

\item{a1}{Sample allocation proportion for group 1.}
}
\value{
A dataframe with variables \code{Chi2 Joint}, \code{Maximum Joint}, \code{Bonferroni} methods. The first entry is the required number of cause-1 failures and the second entry is the required total number of patients.
}
\description{
Power Analysis Tool for Joint Testing Hazards with Competing Risks Data.
}
\examples{
library(powerCompRisk)
powerCompRisk(alpha = 0.05, beta = 0.2, lambda_11 = 0.3, RR = 0.8,
HR_1 = 1.44, HR_all = 1.33, attrition = 0.1, r = 1,f = 8, a1 = 0.5)
}
\references{
Yang, Q., Fung, W.K., Li, G. (2017) Sample size determination for jointly testing a cause-specific hazard and the any-cause hazard in the presence of competing risks. UCLA Department of Biostatistics Technical Report.
}
