% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplaplace.R, R/pplaplace.R, R/qplaplace.R,
%   R/rplaplace.R
\name{PowerLaplace}
\alias{PowerLaplace}
\alias{dplaplace}
\alias{PowerLaplace}
\alias{pplaplace}
\alias{PowerLaplace}
\alias{qplaplace}
\alias{PowerLaplace}
\alias{rplaplace}
\title{The Power Laplace Distribution}
\usage{
dplaplace(x, lambda = 1, mu = 0, sigma = 1, log = FALSE)

pplaplace(q, lambda = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

qplaplace(p, lambda = 1, mu = 0, sigma = 1, lower.tail = TRUE,
  log.p = FALSE)

rplaplace(n, lambda = 1, mu = 0, sigma = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{shape parameter.}

\item{mu, sigma}{location and scale parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x ]}, otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\description{
Density, distribution function,
quantile function and random generation for
the power Laplace distribution with parameters mu, sigma and lambda.
}
\details{
The power Laplace distribution has density

\eqn{f(x)=\lambda\left[\frac{1}{2}+\frac{\left(1-e^{-\frac{\left|x-\mu\right|}{\sigma}}\right)}{2}\textrm{sign}\left(\frac{x-\mu}{\sigma}\right)\right]^{\lambda-1}\left[\frac{e^{-\frac{\left|x-\mu\right|}{\sigma}}}{2\sigma}\right]}{b},
where \eqn{-\infty<\mu<\infty} is the location paramether, \eqn{\sigma^2>0} the scale parameter and \eqn{\lambda>0} the shape parameter.
}
\examples{
dplaplace(1, 1, 3, 4)
pplaplace(1, 1, 3, 4)
qplaplace(0.2, 1, 3, 4)
rplaplace(5, 2, 3, 4)
}
