% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poth-package.R
\docType{package}
\name{poth-package}
\alias{poth-package}
\title{poth: Brief overview of methods and general hints}
\description{
R package \bold{poth} allows to calculate the precision of treatment
hierarchy (POTH) metric to quantify the uncertainty in a treatment hierarchy
in network meta-analysis (Wigle et al., 2024).
}
\details{
R package \bold{poth} provides the following methods:
\itemize{
\item Calculate the separation in ranking metric (\code{\link{poth}})
\item Conduct leave-one-out analysis (\code{\link{loo.poth}})
}

Type \code{help(package = "poth")} for a listing of R functions
available in \bold{poth}.

Type \code{citation("poth")} on how to cite \bold{poth} in
publications.

The development version of \bold{poth} is available on GitHub
\url{https://github.com/augustinewigle/poth}.
}
\references{
Wigle A, Béliveau A, Salanti G, Rücker G, Schwarzer G, Mavridis D,
Nikolakopoulou A (2024):
Precision of treatment hierarchy: A metric for quantifying uncertainty in
treatment hierarchies in network meta-analysis.
Preprint on arXiv, \doi{10.48550/arXiv.2501.11596}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/augustinewigle/poth}
  \item Report bugs at \url{https://github.com/augustinewigle/poth/issues}
}

}
\author{
Augustine Wigle \email{amhwigle@uwaterloo.ca},
  Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{package}
