% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvar-slice.R
\name{rvar-slice}
\alias{rvar-slice}
\alias{[[.rvar}
\alias{[[<-.rvar}
\alias{[.rvar}
\alias{[<-.rvar}
\title{Random variable slicing}
\usage{
\method{[[}{rvar}(x, i, ...)

\method{[[}{rvar}(x, i, ...) <- value

\method{[}{rvar}(x, ..., drop = FALSE)

\method{[}{rvar}(x, i, ...) <- value
}
\arguments{
\item{x}{an \code{\link{rvar}}.}

\item{i, ...}{indices; see \emph{Details}.}

\item{value}{(\code{rvar} or coercable to \code{rvar}) Value to insert into
\code{x} at the location determined by the indices.}

\item{drop}{(logical) Should singular dimensions be dropped when slicing
array \code{\link{rvar}}s? Unlike base array slicing operations, defaults to \code{FALSE}.}
}
\description{
Operations for slicing \code{\link{rvar}}s and replacing parts of \code{\link{rvar}}s.
}
\details{
The \code{\link{rvar}} slicing operators (\code{[} and \code{[[}) attempt to implement the same
semantics as the \link[base:Extract]{base array slicing operators}. There are some
exceptions; most notably, \code{\link{rvar}} slicing defaults to \code{drop = FALSE} instead
of \code{drop = TRUE}.
}
\section{Extracting or replacing single elements with \code{[[}}{


The \code{[[} operator extracts (or replaces) single elements. It always
returns (or replaces) a scalar (length-1) \code{\link{rvar}}.

The \code{x[[i,...]]} operator can be used as follows:
\itemize{
\item \verb{x[[<numeric>]]} for scalar numeric \code{i}: gives the \code{i}th element of \code{x}. If \code{x} is
multidimensional (i.e. \code{length(dim(x)) > 1}), extra dimensions are ignored
when indexing. For example, if \code{x} is a \eqn{6 \times 2} \code{\link{rvar}} array, the
7th element, \code{x[[7]]}, will be the first element of the second column, \code{x[1,2]}.
\item \verb{x[[<numeric rvar>]]} for scalar numeric \code{\link{rvar}} \code{i}: a generalization of indexing when
\code{i} is a scalar numeric. Within each draw of \code{x}, selects the element
corresponding to the value of \code{i} within that same draw.
\item \verb{x[[<character>]]} for scalar character \code{i}: gives the element of \code{x} with name
equal to \code{i}. \strong{Unlike with base arrays}, does not work with
multidimensional \code{\link{rvar}}s.
\item \code{x[[i_1,i_2,...,i_n]]} for scalar numeric or character \code{i_1}, \code{i_2}, etc.
Must provide exactly the same number of indices as dimensions in \code{x}. Selects
the element at the corresponding position in the \code{\link{rvar}} by number and/or
dimname (as a string).
}
}

\section{Extracting or replacing multiple elements with \code{[}}{


The \code{[} operator extracts (or replaces) multiple elements. It always returns
(or replaces) a possibly-multidimensional \code{\link{rvar}}.

The \code{x[i,...]} operator can be used as follows:
\itemize{
\item \verb{x[<logical>]} for vector logical \code{i}: \code{i} is recycled to the same length as \code{x},
ignoring multiple dimensions in \code{x}, then an \code{\link{rvar}} vector is returned
containing the elements in \code{x} where \code{i} is \code{TRUE}.
\item \verb{x[<logical rvar>]} for scalar logical \code{\link{rvar}} \code{i}: returns an \code{\link{rvar}} the same shape
as \code{x} containing only those draws where \code{i} is \code{TRUE}.
\item \verb{x[<numeric>]} for vector numeric \code{i}: an \code{\link{rvar}} vector is returned
containing the \code{i}th elements of \code{x}, ignoring dimensions.
\item \verb{x[<matrix>]} for numeric matrix \code{i}, where \code{ncol(i) == length(dim(x))}: each row
of \code{i} should give the multidimensional index for a single element in \code{x}. The
result is an \code{\link{rvar}} vector of length \code{nrow(i)} containing elements of \code{x}
selected by each row of \code{i}.
\item \code{x[i_1,i_2,...,i_n]} for vector numeric, character, or logical \code{i_1},
\code{i_2}, etc. Returns a slice of \code{x} containing all elements from the dimensions
specified in \code{i_1}, \code{i_2}, etc. If an argument is left empty, all elements
from that dimension are included. Unlike base arrays, trailing dimensions
can be omitted entirely and will still be selected; for example, if \code{x} has
three dimensions, both \code{x[1,,]} and \code{x[1,]} can be used to create a
slice that includes all elements from the last two dimensions. Unlike base
arrays, \code{[} defaults to \code{drop = FALSE}, so results retain the same number of
dimensions as \code{x}.
}
}

\examples{
x <- rvar(array(1:24, dim = c(4,2,3)))
dimnames(x) <- list(c("a","b"), c("d","e","f"))
x

## Slicing single elements
# x[[<numeric>]]
x[[2]]

# x[[<numeric rvar>]]
# notice the draws of x[1:4]...
draws_of(x[1:4])
x[[rvar(c(1,3,4,4))]]
# ... x[[rvar(c(1,3,4,4))]] creates a mixures of those draws
draws_of(x[[rvar(c(1,3,4,4))]])

# x[[i_1,i_2,...]]
x[[2,"e"]]


## Slicing multiple elements
# x[<logical>]
x[c(TRUE,TRUE,FALSE)]

# x[<logical rvar>]
# select every other draw
x[rvar(c(TRUE,FALSE,TRUE,FALSE))]

# x[<numeric>]
x[1:3]

# x[<matrix>]
x[rbind(
  c(1,2),
  c(1,3),
  c(2,2)
)]

# x[i_1,i_2,...,i_n]
x[1,]
x[1,2:3]
x[,2:3]
}
