% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence.R
\name{ess_mean}
\alias{ess_mean}
\alias{ess_mean.default}
\alias{ess_mean.rvar}
\title{Effective sample size for the mean}
\usage{
ess_mean(x, ...)

\method{ess_mean}{default}(x, ...)

\method{ess_mean}{rvar}(x, ...)
}
\arguments{
\item{x}{(multiple options) One of:
\itemize{
\item A matrix of draws for a single variable (iterations x chains). See
\code{\link[=extract_variable_matrix]{extract_variable_matrix()}}.
\item An \code{\link{rvar}}.
}}

\item{...}{Arguments passed to individual methods (if applicable).}
}
\value{
If the input is an array, returns a single numeric value. If any of the draws
is non-finite, that is, \code{NA}, \code{NaN}, \code{Inf}, or \code{-Inf}, the returned output
will be (numeric) \code{NA}. Also, if all draws within any of the chains of a
variable are the same (constant), the returned output will be (numeric) \code{NA}
as well. The reason for the latter is that, for constant draws, we cannot
distinguish between variables that are supposed to be constant (e.g., a
diagonal element of a correlation matrix is always 1) or variables that just
happened to be constant because of a failure of convergence or other problems
in the sampling process.

If the input is an \code{\link{rvar}}, returns an array of the same dimensions as the
\code{\link{rvar}}, where each element is equal to the value that would be returned by
passing the draws array for that element of the \code{\link{rvar}} to this function.
}
\description{
Compute an effective sample size estimate for a mean (expectation)
estimate of a single variable.
}
\examples{
mu <- extract_variable_matrix(example_draws(), "mu")
ess_mean(mu)

d <- as_draws_rvars(example_draws("multi_normal"))
ess_mean(d$Sigma)

}
\references{
Andrew Gelman, John B. Carlin, Hal S. Stern, David B. Dunson, Aki Vehtari and
Donald B. Rubin (2013). \emph{Bayesian Data Analysis, Third Edition}. Chapman and
Hall/CRC.
}
