% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convt.R
\name{convt}
\alias{convt}
\title{Calculate time to convergence}
\usage{
convt(A, vector = "n", accuracy = 0.01, iterations = 1e+05)
}
\arguments{
\item{A}{a square, non-negative numeric matrix of any dimension}

\item{vector}{(optional) a numeric vector or one-column matrix describing 
the age/stage distribution used to calculate the projection.}

\item{accuracy}{the accuracy with which to determine convergence on 
asymptotic growth, expressed as a proportion (see details).}

\item{iterations}{the maximum number of iterations of the model before the 
code breaks.  For slowly-converging models and/or high specified convergence
accuracy, this may need to be increased.}
}
\value{
If \code{vector} is specified, the convergence time of \code{vector} projected
through \code{A}.

If \code{vector} is not specified, a numeric vector of convergence times for 
corresponding stage-biased projections: the length of the vector is equal to 
the dimension of \code{A}; the first entry is the convergence time of 
[1,0,0,...], the second entry is the convergence time of [0,1,0,...], etc.).
}
\description{
Calculate the time to convergence of a population matrix projection model
from the model projection
}
\details{
\code{convt} works by simulating the given model and manually 
determining growth when convergence to the given \code{accuracy} is reached. 
Convergence on an asymptotic growth is deemed to have been reached when the 
growth of the model stays within the window determined by \code{accuracy} for 
10*s iterations of the model, with s equal to the dimension of \code{A}. For 
example, projection of an 8 by 8 matrix with convergence accuracy of 1e-2 is 
deemed to have converged on asymptotic growth when 10*8=80 consecutive 
iterations of the model have a growth within 1-1e-2=0.99 (i.e. 99\%) and 
1+1e-2=1.01 (i.e. 101\%) of each other.

If \code{vector} is specified, the convergence time of the projection of 
\code{vector} through \code{A} is returned. If \code{vector="n"} then 
asymptotic growths of the set of 'stage-biased' vectors are calculated. These 
projections are achieved using a set of standard basis vectors equal in number 
to the dimension of \code{A}. These have every element equal to 0, except for 
a single element equal to 1, i.e. for a matrix of dimension 3, the set of 
stage-biased vectors are: \code{c(1,0,0)}, \code{c(0,1,0)} and 
\code{c(0,0,1)}.

Due to the way in which convergence is defined, \code{convt} can 
only properly work for strongly ergodic models. Therefore, it will not 
function for imprimitive (therefore potentially weakly ergodic) or reducible 
(therefore potentially nonergodic) models.
}
\examples{
 # Create a 3x3 PPM
 ( A <- matrix(c(0,1,2,0.5,0.1,0,0,0.6,0.6), byrow=TRUE, ncol=3) )

 # Create an initial stage structure
 ( initial <- c(1,3,2) )

 # Calculate the convergence time of the 3 stage-biased 
 # populations within 0.1\% of lambda-max
 ( convt(A, accuracy=1e-3) )

 # Calculate the convergence time of the projection of initial and A
 # to within 0.001\% of lambda-max
 ( convt(A, vector=initial, accuracy=1e-5) )

}
\references{
\itemize{
 \item Stott et al. (2011) Ecol. Lett., 14, 959-970.
}
}
\seealso{
Other ConvergenceMeasures: 
\code{\link{dr}()},
\code{\link{truelambda}()}
}
\concept{ConvergenceMeasures}
\concept{converge}
\concept{convergence}
\concept{project}
\concept{projection}
