% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition-class.R
\name{transition}
\alias{*.transition}
\alias{is.transition}
\alias{parameters.transition}
\alias{parameters<-.transition}
\alias{print.transition}
\alias{tr}
\alias{transition}
\title{transition objects}
\usage{
transition(formula, transfun)

tr(formula, transfun)

is.transition(x)

\method{print}{transition}(x, ...)

\method{*}{transition}(x, y)

\method{parameters}{transition}(x)

\method{parameters}{transition}(x) <- value
}
\arguments{
\item{formula}{a two-sided formula identifying the states between which the
transition occurs}

\item{transfun}{a \code{\link{transfun}} object quantifying the transition.}

\item{x}{an object to print or test as a transition object}

\item{y}{a transition object to be multiplied with another with the same
pathway}

\item{value}{a named list of parameters matching those currently defined for \code{x}}

\item{\dots}{further arguments passed to or from other methods.}
}
\description{
creates a \code{transition} object, encoding a transition
  between two states. E.g. the probability of a seed germinating, or of an
  individual surviving in each time step
}
\details{
\code{tr} is just a shorthand for \code{transition}

multiplication of transition objects with the same pathway results
  in a transition object whose \code{transfun} object is a compound of the
  two transfuns in the transitions. See \code{\link{transfun}} for more
  details of compound transfuns.
}
\examples{
# 50/50 chance of a larva emerging from an egg
hatching <- tr(larva ~ egg, p(0.5))

# three eggs laid per adult per time step
fecundity <- tr(egg ~ adult, r(3))

# 0.1 probability of a larva pupating into an adult
pupa <- tr(adult ~ larva, p(0.1))

# print method
print(pupa)

# make a compound transition to include a probability of laying eggs
prob_laying <- tr(egg ~ adult, p(0.6))
(recruitment <- prob_laying * fecundity)

# extract the transfun parameters
(param_pupa <- parameters(pupa))
(param_recruitment <- parameters(recruitment))

# update the parameters of these transfuns
param_pupa$p <- 0.6
parameters(pupa) <- param_pupa
parameters(pupa)

param_recruitment$r <- 15
parameters(recruitment) <- param_recruitment
parameters(recruitment)
}

