% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfun_dispersal.R
\name{dispersal}
\alias{d}
\alias{dispersal}
\alias{is.dispersal}
\title{dispersal transfun}
\usage{
dispersal(value)

d(value)

is.dispersal(x)
}
\arguments{
\item{value}{the (positive) exponential rate of decay of dispersal
probabilities. Large values imply shorter range dispersal.}

\item{x}{an object to be tested as a dispersal transfun object}
}
\description{
Create a transfun object representing a relative probability of
  dispersal between patches. Typically used inside a call to
  \code{\link{transition}}
}
\details{
\code{d()} is a shorthand for \code{dispersal()}. The
  \code{transfun} object returned, when applied to a \code{landscape} object,
  produces a square symmetric matrix, with zero diagonal and off-diagonals
  giving the relative between patch dispersal probability. This implies that
  \emph{all} individuals in the state will \emph{try} to disperse. The
  fraction remaining in the patch depends on \code{value}. To have only some
  fraction try to disperse, a dispersal transfun can be multiplied by a
  probability transfun indicating the probability of attempting dispersal.

  The relative dispersal probability is given by \code{exp(-d * value)},
  where \code{d} is the Euclidean distance between the origin and
  destination patch.
}
\examples{
# these are equivalent
disp <- dispersal(3)
disp <- d(3)

is.dispersal(disp)
}

